//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ComboBoxMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
  // Store initial size of the combo box.
  ComboSmallWidth = cmbCountry->Width;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::btnCloseClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::cmbCountryChange(TObject *Sender)
{
  AnsiString sSelectedCountry = cmbCountry->Items->Strings[cmbCountry->ItemIndex];
  edtCountryName->Text = sSelectedCountry.SubString(7,99);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::cmbCountryDropDown(TObject *Sender)
{
  // Expand the width of the combo box
  cmbCountry->Width = edtCountryName->Width;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::WndProc(TMessage& Message)
{
  if (Message.Msg == WM_COMMAND) {
    {
      int iComboId = (int) LOWORD(Message.WParam); // id of combo box
      HWND hComboBox = (HWND) Message.LParam;      // handle of combo box

      // If this is our expandable combo box,
      // shrink it back to its original size.
      if (hComboBox == cmbCountry->Handle) {
        cmbCountry->Width = ComboSmallWidth;
      }

    }
  }
  TForm::WndProc(Message);
}
