//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "MainForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
  const int ColWidth = DataLV->ClientWidth / 4;
  DataLV->Column[0]->Width = ColWidth;
  DataLV->Column[1]->Width = ColWidth;
  DataLV->Column[2]->Width = ColWidth;
  DataLV->Column[3]->Width = DataLV->ClientWidth -
          ((3 * ColWidth) + GetSystemMetrics(SM_CXVSCROLL));
  m_DataSL = new TStringList;
  m_DataSL->LoadFromFile("TestData.csv");
  StockListView();

  //Initialize to safe default values.
  m_SortAscending = false;
  m_SortColIndex = -1;//Set to a safe default value.

  //Sub-class the listview to allow drawing on it's header.
  OldDataLVWindProc = DataLV->WindowProc;
  DataLV->WindowProc = NewDataLVWindProc;
}//End of form constructor.
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
  delete m_DataSL;
  //Quit subclassing the listview so it can be destroyed properly.
  DataLV->WindowProc = OldDataLVWindProc;
}//End of Form->OnClose().
//---------------------------------------------------------------------------
void __fastcall TForm1::CloseBtnClick(TObject *Sender)
{
  Close();
}//End of CloseBtn->OnClick().
//---------------------------------------------------------------------------
void __fastcall TForm1::DataLVColumnClick(TObject *Sender,
      TListColumn *Column)
{
  const int PrevIndex = m_SortColIndex;
  m_SortColIndex = Column->Index;
  m_SortAscending = !m_SortAscending;

  m_DataSL->CustomSort(CustomSortRecords);
  StockListView();

  //Cause a redraw of the old and new header buttons.  m_SortColIndex
  //must be updated before redrawing the new header button.  The
  //following test is only needed the first time through.
  if(!m_ButtonCaption.IsEmpty())//Redraw the old header button.
    DataLV->Columns->Items[PrevIndex]->Caption = m_ButtonCaption;
  //Store the caption of the new header button.
  m_ButtonCaption = Column->Caption;
  //Redraw the new header button.
  Column->Caption = "";
}//End of DataLV->OnColumnClick().
//---------------------------------------------------------------------------
void TForm1::StockListView()
{
  int DelimitPos;
  String TimeStr, RecordStr;
  TListItem * pListItem;
  DataLV->Items->BeginUpdate();
  DataLV->Items->Clear();
  for(int ii = 0; ii < m_DataSL->Count; ++ii)
  {
    pListItem = DataLV->Items->Add();
    RecordStr = m_DataSL->Strings[ii];
    DelimitPos = RecordStr.Pos(" ");
    //Extract the time information.
    pListItem->Caption = RecordStr.SubString(1, DelimitPos - 1);
    RecordStr.Delete(1, DelimitPos);
    DelimitPos = RecordStr.Pos(",");
    //Extract and format the time information.  
    TimeStr = RecordStr.SubString(1, DelimitPos - 1);
    pListItem->SubItems->Add(StrToTime(TimeStr).FormatString("hh:mm AM/PM"));
    RecordStr.Delete(1, DelimitPos);
    DelimitPos = RecordStr.Pos(",");
    //Extract the flow information.
    pListItem->SubItems->Add(RecordStr.SubString(1, DelimitPos - 1));
    RecordStr.Delete(1, DelimitPos);
    //Extract the signal strength information.  
    RecordStr.SetLength(RecordStr.Length() - 1);
    pListItem->SubItems->Add(RecordStr);
  }//End of for(int ii = 0; ii < m_DataSL->Count; ++ii).
  DataLV->Items->EndUpdate();
}//End of StockListView().
//---------------------------------------------------------------------------
void __fastcall TForm1::NewDataLVWindProc(TMessage &Msg)
{
  LPNMHDR lpnmhdr = reinterpret_cast<LPNMHDR>(Msg.LParam);
  //Must also verify that the message came from the listview's header control.
  if(Msg.Msg == WM_NOTIFY &&
          lpnmhdr->hwndFrom == GetDlgItem(DataLV->Handle, 0))
  {
    //Also test to see if a header button has been clicked.
    if((m_SortColIndex > -1) && (lpnmhdr->code == NM_CUSTOMDRAW))
    {
      LPNMCUSTOMDRAW lpnmcd = reinterpret_cast<LPNMCUSTOMDRAW>(Msg.LParam);
      switch(lpnmcd->dwDrawStage)
      {
        case CDDS_PREPAINT:
          //The following ensures that notification will be sent when
          //every button is about to be drawn.
          Msg.Result = CDRF_NOTIFYITEMDRAW;
        break;
        case CDDS_ITEMPREPAINT:
          //The following cast avoids a compiler warning as
          //lpnmcd->dwItemSpec is typed as a UINT.
          if(static_cast<int>(lpnmcd->dwItemSpec) == m_SortColIndex)
            Msg.Result = CDRF_NOTIFYPOSTPAINT;
        break;
        case CDDS_ITEMPOSTPAINT://Default drawing of item has been done.
            DrawButtonData(lpnmcd);
        break;
      }//End of switch(lpnmcd->dwDrawStage).
      return;
    }//End of if((m_SortColIndex > -1) && (lpnmhdr->code == NM_CUSTOMDRAW)).
  }//End of if(Msg.Msg == WM_NOTIFY && lpnmhdr->hwndFrom == GetDlgItem(...)).
  OldDataLVWindProc(Msg);//Do all normal listview processing.
}//End of NewDataLVWindProc().
//---------------------------------------------------------------------------
void TForm1::DrawButtonData(LPNMCUSTOMDRAW lpnmcd)
{
  TCanvas * const LVHdrCanvas = new TCanvas();
  LVHdrCanvas->Handle = GetDC(lpnmcd->hdr.hwndFrom);
  LVHdrCanvas->Font = DataLV->Font;
  const TSize TextHW = LVHdrCanvas->TextExtent(m_ButtonCaption);
  const int XYOffset = TextHW.cy / 4;
  //Set the vertical position.  YCenterPos will be further updated later.
  int YCenterPos = (lpnmcd->rc.bottom - lpnmcd->rc.top) / 2;

  //Find the total width of the data (the text, the spacing to the center of
  //the triangle, and the right half of the triangle) and the width of the
  //button that the data will be drawn onto.
  const int DataWidth     = TextHW.cx + YCenterPos + XYOffset;
  const int ButtonWidth  = lpnmcd->rc.right - lpnmcd->rc.left;
  if((DataWidth + 10) < ButtonWidth)//Leaves a small buffer.
  {
    RECT DataRect;
    DataRect.left     = lpnmcd->rc.left + (ButtonWidth - DataWidth) / 2;
    DataRect.right    = DataRect.left + DataWidth;
    //Create a buffer so that the top and bottom edges of the text & rectangle
    //won't interfere with the top and bottom lines of the button.
    DataRect.top      = lpnmcd->rc.top + 3;
    DataRect.bottom   = lpnmcd->rc.bottom - 3;

    //Find the horizontal center of the triangle before any adjustments or
    //fudge factors are added to or subtracted from YCenterPos.
    int XCenterPos = DataRect.left + TextHW.cx + YCenterPos;
    //Move the rectangle to the right and down one pixel to make the text
    //and triangle help visually re-enforce any button presses.
    if((lpnmcd->uItemState & CDIS_SELECTED) > 0)//If the button is held down.
    {
      ::OffsetRect(&DataRect, 1, 1);
      ++YCenterPos;
      ++XCenterPos;
    }//End of if((lpnmcd->uItemState & CDIS_SELECTED) > 0).

    //Adjust the vertical fudge factor just for looks.
    if(m_SortAscending)
      YCenterPos -= 2;
    else//Descending order.
      --YCenterPos;

    const int TriLeft   = XCenterPos - XYOffset;
    const int TriRight  = XCenterPos + XYOffset;
    const int TriTop    = YCenterPos - XYOffset;
    const int TriBottom = YCenterPos + XYOffset;

    //Draw the text into the header button.
    ::DrawText(lpnmcd->hdc, m_ButtonCaption.c_str(), m_ButtonCaption.Length(),
            &DataRect, DT_LEFT | DT_SINGLELINE | DT_VCENTER);

    //Draw the sorting triangle.
    if(m_SortAscending)
    {
      //Ascending order.  Sorting arrow points up. 
      //Oldest, smallest, or alphabetically first record is at the top.
      //Start at the bottom left corner and draw clockwise.
      LVHdrCanvas->MoveTo(TriLeft, TriBottom);
      LVHdrCanvas->Pen->Color = clBtnShadow;
      LVHdrCanvas->LineTo(XCenterPos, TriTop);
      LVHdrCanvas->Pen->Color = clBtnHighlight;
      LVHdrCanvas->LineTo(TriRight, TriBottom);
      LVHdrCanvas->LineTo(TriLeft, TriBottom);
    }//End of if(m_SortAscending).
    else
    {
      //Descending order. Sorting arrow points down.
      //Newest, largest, or alphabetically last record is at the top.
      //Start at the bottom center corner and draw clockwise.
      LVHdrCanvas->MoveTo(XCenterPos, TriBottom);
      LVHdrCanvas->Pen->Color = clBtnShadow;
      LVHdrCanvas->LineTo(TriLeft, TriTop);
      LVHdrCanvas->LineTo(TriRight, TriTop);
      LVHdrCanvas->Pen->Color = clBtnHighlight;
      LVHdrCanvas->LineTo(XCenterPos, TriBottom);
    }//End of else.
  }//End of if((DataWidth + 10) < ButtonWidth).
  else  
    ::DrawText(lpnmcd->hdc, m_ButtonCaption.c_str(), m_ButtonCaption.Length(),
      &lpnmcd->rc, DT_CENTER | DT_VCENTER | DT_SINGLELINE | DT_END_ELLIPSIS);
  //Release the system resources used.  MUST call ReleaseDC() first.
  ReleaseDC(lpnmcd->hdr.hwndFrom, LVHdrCanvas->Handle);
  delete LVHdrCanvas;
}//End of DrawButtonData().
//---------------------------------------------------------------------------
int __fastcall TForm1::CustomSortRecords
        (TStringList *List, int Index1, int Index2)
{
  int Result = 0;
  int cLoop = Form1->m_SortColIndex;
  //Adjust for the extra (time) column.
  if(cLoop > 0)
    --cLoop;
  String Str1 = List->Strings[Index1];
  String Str2 = List->Strings[Index2];
  for( ; cLoop > 0; --cLoop)
  {
    Str1.Delete(1, Str1.Pos(","));
    Str2.Delete(1, Str2.Pos(","));
  }//End of for( ; cLoop > 0; --cLoop).
  Str1 = Str1.SubString(1, Str1.Pos(","));
  Str2 = Str2.SubString(1, Str2.Pos(","));
  if(Form1->m_SortAscending)
    Result = Str1.AnsiCompare(Str2);
  else
    Result = Str2.AnsiCompare(Str1);
  return Result;
}//End of CustomSortRecords().
//---------------------------------------------------------------------------

