
//===========================================================================
#ifndef BindStatusCallbackH
#define BindStatusCallbackH
//===========================================================================
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <ComObj.hpp>
#include <urlmon.h>
//---------------------------------------------------------------------------

class DELPHICLASS TBindStatusCallback;
typedef void __fastcall
  (__closure *TDLProgressEvent)(
    TBindStatusCallback* Sender,
    ULONG progress,
    ULONG progress_max,
    ULONG status_code,
    AnsiString status_text,
    bool& cancel
    );

class PACKAGE TBindStatusCallback :
  public TComponent, public IBindStatusCallback
{
__published:
  __property TDLProgressEvent OnDLProgress =
    {read=OnDLProgress_, write=OnDLProgress_};

public:
  __fastcall TBindStatusCallback(TComponent* Owner)
    : TComponent(Owner), IBindStatusCallback(),
      ref_count_(1) {}

  __property LONG RefCount =
    {read = ref_count_, write = ref_count_};

public: // inherited from TComponent
  virtual void __fastcall BeforeDestruction()
    {
      if (ref_count_ > 1)
      {
        throw Exception("Attempting to delete "
          "an object which contains an "
          "external reference.");
      }
    }

public: // inherited from IUnknown
  virtual ULONG STDMETHODCALLTYPE AddRef()
    {
      InterlockedIncrement(&ref_count_);
      return ref_count_;
    }
  virtual ULONG STDMETHODCALLTYPE Release()
    {
      if (InterlockedDecrement(&ref_count_) == 0)
      {
        delete this;
      }
      return ref_count_;
    }
#pragma warn -8022
  virtual HRESULT STDMETHODCALLTYPE
    QueryInterface(REFIID riid, void** ppvObj)
    {
      if (IsEqualIID(riid, IID_IUnknown) ||
          IsEqualIID(riid, IID_IBindStatusCallback))
      {
        *ppvObj =
          static_cast<IBindStatusCallback*>(this);
        AddRef();
        return NOERROR;
      }
      *ppvObj = NULL;
      return E_NOINTERFACE;
    }
#pragma warn .8022

protected: // inherited from IBindStatusCallback
  virtual HRESULT STDMETHODCALLTYPE OnProgress(
    ULONG progress, ULONG progress_max,
    ULONG status_code, LPCWSTR status_text);

  virtual HRESULT STDMETHODCALLTYPE
    GetBindInfo(DWORD* pBinf, BINDINFO* pBindInfo)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE
    GetPriority(LONG* pPriority)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE
    OnDataAvailable(DWORD bscf, DWORD size,
      FORMATETC* pFormatEtc, STGMEDIUM* pStgMed)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE
    OnLowResource(DWORD res)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE
    OnObjectAvailable(REFIID iid, IUnknown* pUnk)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE
    OnStartBinding(DWORD res, IBinding* pBinding)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE
    OnStopBinding(HRESULT hRes, LPCWSTR error_str)
    {
      return E_NOTIMPL;
    }

private:
  TDLProgressEvent OnDLProgress_;
  LONG ref_count_;
};
//---------------------------------------------------------------------------

//===========================================================================
#endif
//===========================================================================

