
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "DownloadThread.h"
#include "urlmon.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "urlmon.lib"
//---------------------------------------------------------------------------

__fastcall TDownloadThread::
  TDownloadThread(bool CreateSuspended)
    : TThread(CreateSuspended),
      Callback_(new
        TBindStatusCallback(NULL))
{
  FreeOnTerminate = true;
  Callback_->OnDLProgress =
    DoCallbackProgress;
}
//---------------------------------------------------------------------------

void __fastcall TDownloadThread::
  DoCallbackProgress(
    TBindStatusCallback* Sender,
    ULONG progress,
    ULONG progress_max,
    ULONG status_code,
    AnsiString status_text,
    bool& cancel)
{
  if (Terminated)
  {
    cancel = true;
    ReturnValue = dltCancel;
    return;
  }

  Progress_ = progress;
  ProgressMax_ = progress_max;
  StatusCode_ = status_code;
  StatusText_ = status_text;

  Synchronize(DoRelayProgress);
}
//---------------------------------------------------------------------------

void __fastcall
  TDownloadThread::Execute()
{
  ReturnValue = dltError;
  Callback_->AddRef();
  try
  {
    // download RemoteFile to LocalFile  
    HRESULT const hRes =
      URLDownloadToFile(
        NULL, RemoteFile_.c_str(),
        LocalFile_.c_str(), 0,
        Callback_.get()
        );
    if (ReturnValue != dltCancel)
    {
      ReturnValue = SUCCEEDED(hRes);
    }
  }
  __finally
  {
    Callback_->Release();
  }
}
//---------------------------------------------------------------------------
