
//---------------------------------------------------------------------------
#ifndef DownloadThreadH
#define DownloadThreadH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include "BindStatusCallback.h"
#include <memory>
//---------------------------------------------------------------------------

enum {dltCancel=-1, dltError, dltSuccess};

class TDownloadThread : public TThread
{
public:
  __fastcall TDownloadThread(bool CreateSuspended);

public:
  __property AnsiString RemoteFile =
    {read=RemoteFile_, write=RemoteFile_};
  __property AnsiString LocalFile =
    {read=LocalFile_, write=LocalFile_};
  __property ULONG Progress =
    {read=Progress_, write=Progress_};
  __property ULONG ProgressMax =
    {read=ProgressMax_, write=ProgressMax_};
  __property ULONG StatusCode =
    {read=StatusCode_, write=StatusCode_};
  __property AnsiString StatusText =
    {read=StatusText_, write=StatusText_};
  __property TNotifyEvent OnDLProgress =
    {read=OnDLProgress_, write=OnDLProgress_};
  __property ReturnValue;

protected:
  virtual void __fastcall Execute();
  virtual void __fastcall DoRelayProgress()
    {
      if (OnDLProgress_ != NULL)
      {
        OnDLProgress_(this);
      }
    }
  virtual void __fastcall DoCallbackProgress(
    TBindStatusCallback* Sender,
    ULONG progress, ULONG progress_max,
    ULONG status_code, AnsiString status_text,
    bool& cancel);

private:
  std::auto_ptr<TBindStatusCallback> Callback_;
  TNotifyEvent OnDLProgress_;
  AnsiString RemoteFile_;
  AnsiString LocalFile_;
  ULONG Progress_;
  ULONG ProgressMax_;
  ULONG StatusCode_;
  AnsiString StatusText_;
};

//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
