
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "DownloadThread.h"
#include "Unit_URLDownload.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "wininet.lib"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

AnsiString Status2Str(ULONG status_code)
{
  switch (status_code)
  {
    case BINDSTATUS_FINDINGRESOURCE:
      return "Locating resource"; 
    case BINDSTATUS_CONNECTING:
      return "Connecting to resource"; 
    case BINDSTATUS_REDIRECTING:
      return "Redirecting to resource"; 
    case BINDSTATUS_BEGINDOWNLOADDATA:
      return "Beginning download"; 
    case BINDSTATUS_DOWNLOADINGDATA:
      return "Downloading"; 
    case BINDSTATUS_ENDDOWNLOADDATA:
      return "Download complete"; 
    case BINDSTATUS_USINGCACHEDCOPY:
      return "Using cached copy";
    case BINDSTATUS_SENDINGREQUEST:
      return "Requesting data";
    case BINDSTATUS_MIMETYPEAVAILABLE:
      return "MIME type available";
    case BINDSTATUS_CACHEFILENAMEAVAILABLE:
      return "Cached file available";
    case BINDSTATUS_DECODING:
      return "Decoding data";
    case BINDSTATUS_DIRECTBIND:
      return "Connection available";
    case BINDSTATUS_PROXYDETECTING:
      return "Proxy server detected";
  }
  return "";
}
//---------------------------------------------------------------------------



__fastcall TForm1::TForm1(TComponent* Owner)
   : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void TForm1::EstimateDLSpeedAndTime()
{
  // compute the change in size (in KB)
  int const this_size = ProgressBar1->Position;
  float const size_change =
    (this_size - last_size_) / 1024.0f;

  // compute the change in time (in secs)
  DWORD const this_tic = GetTickCount();
  float const time_change =
    (this_tic - last_tic_) / 1000.0f;

  if (time_change >= 1)
  {
    last_size_ = this_size;
    last_tic_ = this_tic;

    // display the download speed
    float const speed =
      size_change / time_change;
    ListView1->Items->Item[3]->
      SubItems->Strings[0] = FloatToStrF(
        speed, ffNumber, 4, 1) + " KB/s";

    // secs_left = KB_left / speed
    if (speed > 0)
    {
      int const secs_left = 0.5f +
        (ProgressBar1->Max - this_size) /
        1024.0f / speed;
      ListView1->Items->Item[4]->
        SubItems->Strings[0] = IntToStr(
          secs_left) + " seconds";
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  DownloadThreadProgress(TObject* Sender)
{
  switch (DownloadThread_->StatusCode)
  {
    case BINDSTATUS_FINDINGRESOURCE:
    {
      // display the remote host name
      ListView1->Items->Item[0]->SubItems->
        Strings[0] = DownloadThread_->StatusText;
      break;
    }
    case BINDSTATUS_CONNECTING:
    {
      // display the remote IP address
      ListView1->Items->Item[1]->SubItems->
        Strings[0] = DownloadThread_->StatusText;
      break;
    }
    case BINDSTATUS_MIMETYPEAVAILABLE:
    {
      // display the file's MIME type
      ListView1->Items->Item[2]->SubItems->
        Strings[0] = DownloadThread_->StatusText;
      break;
    }
    case BINDSTATUS_DOWNLOADINGDATA:
    {
      // update the progress bar
      ProgressBar1->Position =
        DownloadThread_->Progress;
      ProgressBar1->Max =
        DownloadThread_->ProgressMax;

      // display the est. download speed
      // and remaining transfer time
      EstimateDLSpeedAndTime();
      break;
    }
    case BINDSTATUS_BEGINDOWNLOADDATA:
    {
      last_size_ = 0;
      last_tic_ = GetTickCount();
      ProgressBar1->Position = 0;
      ProgressBar1->Max =
        DownloadThread_->ProgressMax;
      break;
    }
    case BINDSTATUS_ENDDOWNLOADDATA:
    {
      ProgressBar1->Position =
        ProgressBar1->Max;
      break;
    }
  }

  // translate the status code
  Label1->Caption = Status2Str(
    DownloadThread_->StatusCode);

  // display the num. received bytes
  Label2->Caption = "Received " +
    IntToStr(DownloadThread_->Progress)+ " of " +
    IntToStr(DownloadThread_->ProgressMax) +
    " Bytes";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  DownloadActionExecute(TObject *Sender)
{
  // define and check the URL
  WideString const url(URLEdit->Text);
  HRESULT const hRes =
    IsValidURL(NULL, url.c_bstr(), 0);
  if (hRes != S_OK)
  {
    Application->MessageBox(
       "Invalid URL.",
       Application->Title.c_str(),
       MB_OK | MB_ICONERROR
       );
    URLEdit->SetFocus();
    URLEdit->SelectAll();
    return;
  }

  // define the local file
  int const idx =
    LastDelimiter("/", url) + 1;
  SaveDialog1->FileName = url.SubString(
    idx, url.Length() - idx + 1
    );
  if (SaveDialog1->Execute())
  {
    // download the file...
    DownloadThread_ =
      new TDownloadThread(true);
    try
    {
      DownloadThread_->OnTerminate =
        DownloadThreadTerminate;
      DownloadThread_->OnDLProgress =
        DownloadThreadProgress;
      DownloadThread_->RemoteFile = url;
      DownloadThread_->LocalFile =
        SaveDialog1->FileName;

      // clear the file from
      // the cache (optional)
      DeleteUrlCacheEntry(
        DownloadThread_->
          RemoteFile.c_str());

      DownloadAction->Enabled = false;
      CancelAction->Enabled = true;
    }
    __finally
    {
      DownloadThread_->Resume();
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  CancelActionExecute(TObject *Sender)
{
  DownloadThread_->Terminate();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  DownloadThreadTerminate(TObject* Sender)
{
  switch (DownloadThread_->ReturnValue)
  {
    case dltCancel: // DL cancelled
      Application->MessageBox(
        "Download cancelled.",
        Application->Title.c_str(),
        MB_ICONWARNING | MB_OK
        );
      break;
    case dltError: // DL error
      Application->MessageBox(
        "Error downloading file.",
        Application->Title.c_str(),
        MB_ICONERROR | MB_OK
        );
      break;
    case dltSuccess: // DL success
      Application->MessageBox(
        "Download complete.",
        Application->Title.c_str(),
        MB_ICONINFORMATION | MB_OK
        );
      break;
  }

  // clear the file from the cache (optional)
  DeleteUrlCacheEntry(
    DownloadThread_->RemoteFile.c_str());

  // clean up
  for (int idx = 0; idx < 5; ++idx)
  {
    ListView1->Items->Item[idx]->
      SubItems->Strings[0] = "";
  }
  Label1->Caption = "";
  Label2->Caption = "";
  ProgressBar1->Max = 0;
  DownloadAction->Enabled = true;
  CancelAction->Enabled = false;  
}
//---------------------------------------------------------------------------

