
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "scrollboxex.h"
#include "ResizeGrips.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
   ScrollBoxEx1_ = new TScrollBoxEx(this);
   ScrollBoxEx1_->Parent = this;
   ScrollBoxEx1_->SetBounds(10, 10, 200, 250);
   ScrollBoxEx1_->BorderStyle = bsSingle;
   ScrollBoxEx1_->HorzScrollBar->Range = 600;
   ScrollBoxEx1_->VertScrollBar->Range = 600;
   ScrollBoxEx1_->OnMouseDown = ScrollBoxExsMouseDown;
   ScrollBoxEx1_->Tag = 1;

   ScrollBoxEx2_ = new TScrollBoxEx(this);
   ScrollBoxEx2_->Parent = this;
   ScrollBoxEx2_->Brush->Style = bsClear;
   ScrollBoxEx2_->SetBounds(230, 10, 200, 250);
   ScrollBoxEx2_->OnMouseDown = ScrollBoxExsMouseDown;
   ScrollBoxEx2_->GripSize = 8;
   ScrollBoxEx2_->Tag = 2;
   Image1->Parent = ScrollBoxEx2_;
   Image1->Align = alClient;
   Image1->Enabled = false;

   ScrollBoxEx3_ = new TScrollBoxEx(this);
   ScrollBoxEx3_->Parent = this;
   ScrollBoxEx3_->Brush->Style = bsClear;
   ScrollBoxEx3_->OnResize = ScrollBoxEx3Resize;
   ScrollBoxEx3_->SetBounds(460, 10, 200, 250);
   ScrollBoxEx3_->OnMouseDown = ScrollBoxExsMouseDown;
   ScrollBoxEx3_->GripSize = 10;   
   ScrollBoxEx3_->Tag = 3;
   Shape1->Parent = ScrollBoxEx3_;
   Shape1->Align = alClient;
   Shape1->Enabled = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ScrollBoxExsMouseDown(TObject* Sender,
   TMouseButton Button, TShiftState Shift, int X, int Y)
{
   TScrollBoxEx& ScrollBoxEx =
      static_cast<TScrollBoxEx&>(*Sender);

   // deselect all other scroll boxes
   if (ScrollBoxEx.Tag != ScrollBoxEx1_->Tag)
      ScrollBoxEx1_->MoveResize = false;
   if (ScrollBoxEx.Tag != ScrollBoxEx2_->Tag)
      ScrollBoxEx2_->MoveResize = false;
   if (ScrollBoxEx.Tag != ScrollBoxEx3_->Tag)
      ScrollBoxEx3_->MoveResize = false;

   Application->ProcessMessages();
   ScrollBoxEx.MoveResize = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormMouseDown(TObject* Sender,
   TMouseButton Button, TShiftState Shift, int X, int Y)
{
   ScrollBoxEx1_->MoveResize = false;
   ScrollBoxEx2_->MoveResize = false;
   ScrollBoxEx3_->MoveResize = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ScrollBoxEx3Resize(TObject* Sender)
{
   HRGN hEllipticRgn = CreateEllipticRgn(
      0, 0, ScrollBoxEx3_->Width, ScrollBoxEx3_->Height
      );
   if (!SetWindowRgn(ScrollBoxEx3_->Handle, hEllipticRgn, TRUE))
   {
      DeleteObject(hEllipticRgn);
   }
}
//---------------------------------------------------------------------------

