
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "scrollboxex.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------

__fastcall TScrollBoxEx::TScrollBoxEx(TComponent* Owner)
   : TScrollBox(Owner), GripSize_(6),
   MoveResize_(false), OldCursor_(crDefault)
{
   BorderStyle = bsNone;
   for (int indx = 0; indx < 8; ++indx)
   {
      TPanel* Panel = new TPanel(this);
      Panel->Visible = false;
      Panel->BevelOuter = bvNone;
      Panel->Color = clBlack;
      Panel->OnMouseDown = PanelsMouseDown;
      Panel->Tag = indx;

      switch (indx)
      {
         case 0:
         case 4:
         {
            Panel->Cursor = crSizeNWSE;
            break;
         }
         case 1:
         case 5:
         {
            Panel->Cursor = crSizeNS;
            break;
         }
         case 2:
         case 6:
         {
            Panel->Cursor = crSizeNESW;
            break;
         }
         case 3:
         case 7:
         {
            Panel->Cursor = crSizeWE;
            break;
         }
      }

      // add the panel to the list
      Panels_.push_back(Panel);
   }
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::PanelsMouseDown(
    TObject *Sender, TMouseButton Button,
    TShiftState Shift, int X, int Y
   )
{
   TComponent& Panel = static_cast<TComponent&>(*Sender);

   int code = HTNOWHERE;
   switch (Panel.Tag)
   {
      case 0: code = HTTOPLEFT; break;
      case 1: code = HTTOP; break;
      case 2: code = HTTOPRIGHT; break;
      case 3: code = HTRIGHT; break;
      case 4: code = HTBOTTOMRIGHT; break;
      case 5: code = HTBOTTOM; break;
      case 6: code = HTBOTTOMLEFT; break;
      case 7: code = HTLEFT; break;
   }

   // release current mouse capture
   ReleaseCapture();

   // fake a sizing border hit
   SendMessage(
      Handle, WM_NCLBUTTONDOWN, code, 0
      );
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::SetBounds(
    int ALeft, int ATop, int AWidth, int AHeight
   )
{
   TScrollBox::SetBounds(ALeft, ATop, AWidth, AHeight);
   if (!ControlState.Contains(csCreating))
   {
      DoShowGrips(MoveResize_);
   }
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::MouseDown(
   TMouseButton Button, TShiftState Shift, int X, int Y
  )
{
   TScrollBox::MouseDown(Button, Shift, X, Y);
   if (MoveResize_)
   {
      // release current mouse capture
      ReleaseCapture();

      // fake a caption hit
      SNDMSG(Handle, WM_NCLBUTTONDOWN, HTCAPTION, 0);

      // bring the panels to the front
      for (int indx = 0; indx < 8; ++indx)
      {
         Panels_[indx]->BringToFront();
      }
   }
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::WMSizing(TMessage& Msg)
{
   //
   // handle any sizing-related stuff here...
   //

   // pass the message on
   TScrollBox::Dispatch(&Msg);
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::WMMoving(TMessage& Msg)
{
   //
   // handle any moving-related stuff here...
   //

   // pass the message on
   TScrollBox::Dispatch(&Msg);
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::WMEnterSizeMove(TMessage& Msg)
{
   // hide the panels
   DoShowGrips(false);

   // pass the message on
   TScrollBox::Dispatch(&Msg);
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::WMExitSizeMove(TMessage& Msg)
{
   // reshow and reposition the panels
   DoShowGrips(true);

   // pass the message on
   TScrollBox::Dispatch(&Msg);
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::DoSetMoveResize(bool value)
{
   if (MoveResize_ != value)
   {
      MoveResize_ = value;
      if (MoveResize_)
      {
         // change the cursor to crSizeAll
         OldCursor_ = Cursor;
         Cursor = crSizeAll;
      }
      else
      {
         // restore the cursor
         Cursor = OldCursor_;
      }
      
      // display the resizing grips
      DoShowGrips(value);
   }
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::DoSetGripSize(int value)
{
   if (GripSize_ != value)
   {
      GripSize_ = value;
      DoShowGrips(MoveResize_);
   }
}
//---------------------------------------------------------------------------

void __fastcall TScrollBoxEx::DoShowGrips(bool show)
{
   if (show)
   {
      const int half_grip_size = 0.5 + 0.5 * GripSize_;

      const TRect BR = BoundsRect;
      Panels_[0]->SetBounds(
        BR.Left - half_grip_size,
        BR.Top - half_grip_size,
        GripSize_, GripSize_
        );
      Panels_[1]->SetBounds(
        BR.Left + 0.5 * Width - half_grip_size,
        BR.Top - half_grip_size,
        GripSize_, GripSize_
        );
      Panels_[2]->SetBounds(
        BR.Right - half_grip_size,
        BR.Top - half_grip_size,
        GripSize_, GripSize_
        );
      Panels_[3]->SetBounds(
        BR.Right - half_grip_size,
        BR.Top + 0.5 * Height - half_grip_size,
        GripSize_, GripSize_
        );
      Panels_[4]->SetBounds(
        BR.Right - half_grip_size,
        BR.Bottom - half_grip_size,
        GripSize_, GripSize_
        );
      Panels_[5]->SetBounds(
        BR.Left + 0.5 * Width - half_grip_size,
        BR.Bottom - half_grip_size,
        GripSize_, GripSize_
        );
      Panels_[6]->SetBounds(
        BR.Left - half_grip_size,
        BR.Bottom - half_grip_size,
        GripSize_, GripSize_
        );
      Panels_[7]->SetBounds(
        BR.Left - half_grip_size,
        BR.Top + 0.5 * Height - half_grip_size,
        GripSize_, GripSize_
        );

      const int num_grips = Panels_.size();        
      for (int indx = 0; indx < num_grips; ++indx)
      {
         Panels_[indx]->Parent = Parent;
         Panels_[indx]->Visible = true;
         Panels_[indx]->BringToFront();
      }
   }
   else
   {
      const int num_grips = Panels_.size();
      for (int indx = 0; indx < num_grips; ++indx)
      {
         Panels_[indx]->Visible = false;
      }
   }
}
//---------------------------------------------------------------------------

