
//---------------------------------------------------------------------------
#ifndef SCROLLBOXEX_H
#define SCROLLBOXEX_H
//---------------------------------------------------------------------------

#include <Classes.hpp>
#include <Controls.hpp>
#include <Forms.hpp>

#include <vector>
//---------------------------------------------------------------------------

class TScrollBoxEx : public TScrollBox
{
typedef std::vector<TPanel*> TPanels;
public:
   __fastcall TScrollBoxEx(TComponent* Owner);

   __property int GripSize =
      {read = GripSize_, write = DoSetGripSize};
   __property bool MoveResize =
      {read = MoveResize_, write = DoSetMoveResize};

   virtual void __fastcall SetBounds(int ALeft, int ATop,
      int AWidth, int AHeight);
      
protected:
   // inherited member functions
   DYNAMIC void __fastcall MouseDown(TMouseButton Button,
      TShiftState Shift, int X, int Y);

   // introduced member function
   virtual void __fastcall DoSetMoveResize(bool value);
   virtual void __fastcall DoSetGripSize(int value);   
   virtual void __fastcall DoShowGrips(bool show);

private:
   int GripSize_;
   bool MoveResize_;
   TCursor OldCursor_;
   TPanels Panels_;

   void __fastcall PanelsMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y);

   MESSAGE void __fastcall WMSizing(TMessage& Msg);
   MESSAGE void __fastcall WMMoving(TMessage& Msg);
   MESSAGE void __fastcall WMEnterSizeMove(TMessage& Msg);
   MESSAGE void __fastcall WMExitSizeMove(TMessage& Msg);

public:
BEGIN_MESSAGE_MAP
   MESSAGE_HANDLER(WM_SIZING, TMessage, WMSizing)
   MESSAGE_HANDLER(WM_MOVING, TMessage, WMMoving)
   MESSAGE_HANDLER(WM_ENTERSIZEMOVE, TMessage, WMEnterSizeMove)
   MESSAGE_HANDLER(WM_EXITSIZEMOVE, TMessage, WMExitSizeMove)
END_MESSAGE_MAP(TScrollBox)
};

//---------------------------------------------------------------------------
#endif // SCROLLBOXEX_H
//---------------------------------------------------------------------------
