// ************************************************************************ //
// Implementation class for interface IHeadline
// ************************************************************************ //
#include <vcl.h>
#pragma hdrstop

#include <IniFiles.hpp>

#if !defined(HeadlineH)
#include "Headline.h"
#endif

// ************************************************************************ //
//  THeadlineImpl implements interface IHeadline
// ************************************************************************ //
class THeadlineImpl : public TInvokableClass, public IHeadline
{
public:
  AnsiString FNews;
  virtual AnsiString STDMETHODCALLTYPE LatestNews(void);
  virtual void STDMETHODCALLTYPE UpdateNews(AnsiString pw, AnsiString News);

  /* IUnknown */
  HRESULT STDMETHODCALLTYPE QueryInterface(const GUID& IID, void **Obj)
                        { return GetInterface(IID, Obj) ? S_OK : E_NOINTERFACE; }
  ULONG STDMETHODCALLTYPE AddRef() { return TInterfacedObject::_AddRef();  }
  ULONG STDMETHODCALLTYPE Release(){ return TInterfacedObject::_Release(); }

  /* Ensures that the class is not abstract */
  void checkValid() { delete new THeadlineImpl(); }
};

AnsiString STDMETHODCALLTYPE THeadlineImpl::LatestNews(void)
{
  return FNews;
};

void STDMETHODCALLTYPE THeadlineImpl::UpdateNews(AnsiString pw, AnsiString News)
{
  if (pw == "drbob")
  {
    FNews = News;
    TIniFile* newsfile = new TIniFile(".\\_private\\news.ini");
    newsfile->WriteString("News","SoapHead",News);
    newsfile->UpdateFile();
    newsfile->Free();
  }
};


static void __fastcall HeadlineFactory(System::TObject* &obj)
{
  static _di_IHeadline iInstance;
  static THeadlineImpl *instance = 0;
  if (!instance)
  {
    instance = new THeadlineImpl();
    TIniFile* newsfile = new TIniFile(".\\_private\\news.ini");
    instance->FNews = newsfile->ReadString("News","SoapHead","News");
    newsfile->Free();
    instance->GetInterface(iInstance);
  }
  obj = instance;
}

// ************************************************************************ //
//  The following routine registers the interface and implementation class.
// ************************************************************************ //
static void RegTypes()
{
  InvRegistry()->RegisterInterface(__interfaceTypeinfo(IHeadline));
  InvRegistry()->RegisterInvokableClass(__classid(THeadlineImpl), HeadlineFactory);
}
#pragma startup RegTypes 32

