
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "AutoCompleteEdit.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------

static inline void ValidCtrCheck(TAutoCompleteEdit*)
{
  new TAutoCompleteEdit(NULL);
}
//---------------------------------------------------------------------------

namespace Autocompleteedit
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] = {__classid(TAutoCompleteEdit)};
    RegisterComponents("Samples", classes, 0);
  }
}
//---------------------------------------------------------------------------



__fastcall TPopupListBox::TPopupListBox(
  TComponent* Owner) : TListBox(Owner),
  Edit_(NULL)
{
}
//---------------------------------------------------------------------------

void __fastcall TPopupListBox::
  CreateParams(TCreateParams& Prms)
{
  TListBox::CreateParams(Prms);
  Prms.Style |= WS_BORDER;
  Prms.ExStyle |= WS_EX_PALETTEWINDOW;
  Prms.WindowClass.style |= CS_SAVEBITS;
}
//---------------------------------------------------------------------------

void __fastcall
  TPopupListBox::CreateWnd()
{
  TListBox::CreateWnd();
  ::SetParent(
    WindowHandle, GetDesktopWindow());
}
//---------------------------------------------------------------------------

void __fastcall TPopupListBox::
  MouseMove(TShiftState Shift,
  int X, int Y)
{
  TListBox::MouseMove(Shift, X, Y);

  // find the index of the item over
  // which the mouse cursor is located
  const int index =
    ItemAtPos(Point(X, Y), false);
  if (index != -1)
  {
    // select that item
    ItemIndex = index;
  }
}
//---------------------------------------------------------------------------

void __fastcall TPopupListBox::MouseUp(
  TMouseButton Button, TShiftState Shift,
  int X, int Y)
{
  TListBox::MouseUp(Button, Shift, X, Y);

  // find the index of the item over
  // which the mouse cursor is located
  const int index =
    ItemAtPos(Point(X, Y), true);
  if (index != -1)
  {
    if (Edit_ != NULL)
    {
      // update the edit control
      Edit_->Text =
        Items->Strings[index];
      Edit_->SelectAll();
    }
    // hide the popup list
    Hide();
  }
}
//---------------------------------------------------------------------------



__fastcall TAutoCompleteEdit::
  TAutoCompleteEdit(TComponent* Owner)
   : TEdit(Owner),
     Strings_(new TStringList())
{
  Strings_->Sorted = true;
  Strings_->CaseSensitive = false;
  Strings_->Duplicates = dupIgnore;

  if (!Designing())
  {
    // create the popup list box
    PopupListBox_ =
      new TPopupListBox(this);
    PopupListBox_->Edit = this;
  }

  // Note that the popup list box is
  // created only at run-time.  The
  // Designing() method, which is defined
  // in Listing B, returns a Boolean
  // value that specifies the current
  // paradigm (true = design time,
  // false = run time).
}
//---------------------------------------------------------------------------

void __fastcall TAutoCompleteEdit::
  SetParent(TWinControl* AParent)
{
  TEdit::SetParent(AParent);
  if (!Designing() && AParent != NULL)
  {
    PopupListBox_->Parent =
      ValidParentForm(this);
    PopupListBox_->Visible = false;
    PopupListBox_->BorderStyle = bsNone;
  }
}
//---------------------------------------------------------------------------

void __fastcall
  TAutoCompleteEdit::Change()
{
  TEdit::Change();
  DoUpdatePopupList();
}
//---------------------------------------------------------------------------

void TAutoCompleteEdit::
  DoUpdatePopupList()
{
  // no-op during design time
  if (Designing()) return;

  // clear the current list
  PopupListBox_->Items->Clear();
  // grab the edit control's text
  const AnsiString edit_text(Text);

  // for each string in Strings_
  const int count = Strings_->Count;
  for (int idx = 0; idx < count; ++idx)
  {
    const AnsiString S(
      Strings_->Strings[idx]
      );
    // if the edit control's text matches
    // the current string (S) of Strings_
    if (S.Pos(edit_text) == 1)
    {
      // add S to the popup list box
      PopupListBox_->Items->Add(S);
    }
  }

  // hide or show the list box depending
  // on whether it contains any items
  DoPopupList(PopupListBox_->Count > 0);
}
//---------------------------------------------------------------------------

void TAutoCompleteEdit::
  DoPopupList(bool show)
{
  if (!show)
  {
    // dismiss the popup list box
    PopupListBox_->Hide();
  }
  else
  {
    RECT R;
    // extract the edit control's
    // bounding screen coordinates
    if (GetWindowRect(WindowHandle, &R))
    {
      PopupListBox_->Left = R.left;
      PopupListBox_->Top = R.bottom;
      PopupListBox_->
        Width = R.right - R.left;

      // display the popup list box
      PopupListBox_->Show();
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TAutoCompleteEdit::
  KeyDown(Word &Key, TShiftState Shift)
{
  TEdit::KeyDown(Key, Shift);
  if ((Key == VK_UP || Key == VK_DOWN) &&
      !Designing())
  {
    SNDMSG(PopupListBox_->Handle,
      WM_KEYDOWN, Key, 0);
  }
}
//---------------------------------------------------------------------------

void __fastcall TAutoCompleteEdit::
  KeyPress(char& Key)
{
  // if the user has pressed the enter
  // key, and we're not in design-mode,
  // and the popup list box is visible
  if (Key == '\r' && !Designing() &&
      PopupListBox_->Visible)
  {
    const int index =
      PopupListBox_->ItemIndex;
    if (index != -1)
    {
      // update the current text
      Text = PopupListBox_->
        Items->Strings[index];
      SelectAll();
    }
    // hide the popup list box
    DoPopupList(false);
  }
  TEdit::KeyPress(Key);
}
//---------------------------------------------------------------------------

void __fastcall
  TAutoCompleteEdit::DblClick()
{
  TEdit::DblClick();
  if (Text.Length() == 0)
  {
    PopupListBox_->Items->
      Assign(Strings_.get());
    DoPopupList(true);
  }
}
//---------------------------------------------------------------------------

void __fastcall TAutoCompleteEdit::
  WMKillFocus(TMessage& Msg)
{
  TEdit::Dispatch(&Msg);
  DoPopupList(false);
}
//---------------------------------------------------------------------------
