
//---------------------------------------------------------------------------
#ifndef AutoCompleteEditH
#define AutoCompleteEditH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>

#include <cassert>
#include <memory>
//---------------------------------------------------------------------------

class PACKAGE TPopupListBox : public TListBox
{
__published:
  __property TCustomEdit* Edit =
    {read = Edit_, write = Edit_};

public:
  __fastcall TPopupListBox(TComponent* Owner);

protected: // inherited
  virtual void __fastcall CreateWnd();
  virtual void __fastcall CreateParams(
    TCreateParams& Prms);
  DYNAMIC void __fastcall MouseMove(
    TShiftState Shift, int X, int Y);
  DYNAMIC void __fastcall MouseUp(
    TMouseButton Button, TShiftState Shift,
    int X, int Y);

private:
  TCustomEdit* Edit_;
};
//---------------------------------------------------------------------------

class PACKAGE TAutoCompleteEdit : public TEdit
{
__published:
  __property TStringList* Strings =
    {read = GetStrings, write = SetStrings};

public:
  __fastcall TAutoCompleteEdit(TComponent* Owner);

public:
  __property TPopupListBox* PopupListBox =
    {read = PopupListBox_};
  void PopupList(bool show) { DoPopupList(show); }

protected: // introduced
  virtual void DoUpdatePopupList();
  virtual void DoPopupList(bool show);

protected: // inherited
  virtual void __fastcall SetParent(
    TWinControl* AParent);
  DYNAMIC void __fastcall KeyDown(Word& Key,
    TShiftState Shift);
  DYNAMIC void __fastcall KeyPress(char& Key);
  DYNAMIC void __fastcall Change();
  DYNAMIC void __fastcall DblClick();

private:
  bool Designing()
    {
      return ComponentState.Contains(csDesigning);
    }
  TStringList* __fastcall GetStrings()
    {
      return Strings_.get();
    }
  void __fastcall SetStrings(TStringList* SL)
    {
      Strings_->Assign(SL);
    }
  MESSAGE void __fastcall WMKillFocus(
    TMessage& Msg);

private:
  TPopupListBox* PopupListBox_;
  std::auto_ptr<TStringList> Strings_;

public:
BEGIN_MESSAGE_MAP
  MESSAGE_HANDLER(WM_KILLFOCUS,
TMessage, WMKillFocus)
END_MESSAGE_MAP(TEdit)
};

//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
