#define NO_WIN32_LEAN_AND_MEAN
#include <vcl.h>
#pragma hdrstop

#include <shellapi.h>
#include <shlobj.h>

#include "MainU.h"

#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"
TForm1 *Form1;

__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // Initialize OLE. This is required to get
  // the cut and copy actions to work.
  if (OleInitialize(0) != S_OK) {
    ShowMessage("Unable to initialize OLE.");
    return;
  }
  FileNameEdit->Text = Application->ExeName;
}

void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  // Unitialize OLE
  OleUninitialize();
}

void __fastcall TForm1::GoBtnClick(TObject *Sender)
{
  // Get an IShellFolder for the desktop.
  LPSHELLFOLDER DesktopFolder;
  SHGetDesktopFolder(&DesktopFolder);
  if (!DesktopFolder) {
    ShowMessage(
      "Failed to get Desktop folder.");
    return;
  }

  // Separate the file from the folder.
  String FilePath = ExtractFilePath(
    FileNameEdit->Text);
  String FileName = ExtractFileName(
    FileNameEdit->Text);

  // Get a pidl for the folder the file
  // is located in.
  wchar_t Path[MAX_PATH];
  LPITEMIDLIST ParentPidl;
  DWORD Eaten;
  StringToWideChar(FilePath, Path, MAX_PATH);
  DWORD Result =
    DesktopFolder->ParseDisplayName(
      Handle, 0, Path, &Eaten, &ParentPidl, 0);
  if (Result != NOERROR) {
    ShowMessage("Invalid file name.");
    return;
  }

  // Get an IShellFolder for the folder
  // the file is located in.
  LPSHELLFOLDER ParentFolder;
  DesktopFolder->BindToObject(ParentPidl,
    0, IID_IShellFolder, (void**)&ParentFolder);
  if (!ParentFolder) {
    ShowMessage("Invalid file name.");
    return;
  }

  // Get a pidl for the file itself.
  LPITEMIDLIST Pidl;
  StringToWideChar(
    FileName, Path, MAX_PATH);
  ParentFolder->ParseDisplayName(
    Handle, 0, Path, &Eaten, &Pidl, 0);

  // Get the IContextMenu for the file.
  LPCONTEXTMENU CM;
  ParentFolder->GetUIObjectOf(
    Handle, 1, (LPCITEMIDLIST*)&Pidl,
    IID_IContextMenu, 0, (void**)&CM);

  if (!CM) {
    ShowMessage(
      "Unable to get context menu interface.");
    return;
  }

  // Set up a CMINVOKECOMMANDINFO structure.
  CMINVOKECOMMANDINFO CI;
  ZeroMemory(&CI, sizeof(CI));
  CI.cbSize = sizeof(CMINVOKECOMMANDINFO);
  CI.hwnd = Handle;

  if (Sender == GoBtn) {
    // Verbs that can be used are cut, paste,
    // properties, delete, and so on.
    String Action;
    if (CutRb->Checked)
      Action = "cut";
    else if (CopyRb->Checked)
      Action = "copy";
    else if (DeleteRb->Checked)
      Action = "delete";
    else if (PropertiesRb->Checked)
      Action = "properties";

    CI.lpVerb = Action.c_str();
    Result = CM->InvokeCommand(&CI);
    if (Result)
      ShowMessage(
        "Error copying file to clipboard.");

    // Clean up.
    CM->Release();
    ParentFolder->Release();
    DesktopFolder->Release();
  } else {
    HMENU hMenu = CreatePopupMenu();
    DWORD Flags = CMF_EXPLORE;
    // Optionally the shell will show the extended
    // context menu on some operating systems when
    // the shift key is held down at the time the
    // context menu is invoked. The following is
    // commented out but you can uncommnent this
    // line to show the extended context menu.
    // Flags |= 0x00000080;
    CM->QueryContextMenu(hMenu, 0, 1, 0x7FFF, Flags);

    // Merge the form's popup menu with the shell
    // menu.
    MENUITEMINFO mi;
    char buff[80];
    // Work backwards, adding each item to the
    // top of the shell context menu.
    for (int i=PopupMenu1->Items->Count - 1;i>-1;i--) {
      ZeroMemory(&mi, sizeof(mi));
      mi.dwTypeData = buff;
      mi.cch = sizeof(buff);
      mi.cbSize = 44;
      mi.fMask = MIIM_TYPE | MIIM_ID | MIIM_DATA;
      // Get the menu item.
      DWORD result = GetMenuItemInfo(
        PopupMenu1->Handle, i, true, &mi);
        if (result) {
          // Modify its ID by adding 100 to the
          // Command property. This ensures that
          // there are no conflicts between the
          // shell command IDs and the popup items.
          mi.wID = PopupMenu1->Items->
            Items[i]->Command + 100;
          // Add the item to the shell menu.
          InsertMenuItem(hMenu, 0, true, &mi);
        }
    }
    // Show the menu.
    TPoint pt;
    GetCursorPos(&pt);
    int Cmd = TrackPopupMenu(hMenu,
      TPM_LEFTALIGN | TPM_LEFTBUTTON |
      TPM_RIGHTBUTTON | TPM_RETURNCMD,
      pt.x, pt.y, 0, Handle, 0);
    // Handle the command. If the return value
    // from TrackPopupMenu is less than 100 then
    // a shell item was clicked.
    if (Cmd < 100 && Cmd != 0) {
      CI.lpVerb = MAKEINTRESOURCE(Cmd - 1);
      CI.lpParameters = "";
      CI.lpDirectory = "";
      CI.nShow = SW_SHOWNORMAL;
      CM->InvokeCommand(&CI);
    }
    // If Cmd is > 100 then it's one of our
    // inserted menu items.
    else
      // Find the menu item.
      for (int i=0;i<PopupMenu1->Items->Count;i++) {
        TMenuItem* menu =
          PopupMenu1->Items->Items[i];
        // Call its OnClick handler.
        if (menu->Command == Cmd - 100)
          menu->OnClick(this);
      }
    // Release the memory allocated for the menu.
    DestroyMenu(hMenu);
  }
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  if (OpenDialog->Execute())
    FileNameEdit->Text = OpenDialog->FileName;
}

void __fastcall TForm1::CloseBtnClick(TObject *Sender)
{
  Close();
}

// The OnClick handlers for the poup menu.
void __fastcall TForm1::Hello1Click(TObject *Sender)
{
  ShowMessage("Hello!");
}

void __fastcall TForm1::Test1Click(TObject *Sender)
{
  ShowMessage("This is a test.");
}

