
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(
  TComponent* Owner) : TForm(Owner),
  tic_(0), HintList_(new TStringList())
{
  HintWindow_ = new THintWindow(this);
  HintWindow_->Brush->Color = clInfoBk;

  HintList_->Add( /* ~THintWindow */
    "Frees the memory associated with "
    "the THintWindow object.");
  HintList_->Add( /* ActivateHint */
    "Displays the tooltip.");
  HintList_->Add( /* ActivateHintData */
    "Displays the tooltip using a "
    "provided data value.");
  HintList_->Add( /* CalcHintRect */
    "Returns the size needed to display "
    "a given hint.");
  HintList_->Add( /* IsHintMsg */
    "Determines whether an application "
    "message requires hiding the hint "
    "window.");
  HintList_->Add( /* ReleaseHandle */
    "Destroys the window displayed by "
    "THintWindow.");
  HintList_->Add( /* THintWindow */
    "Creates and initializes an "
    "instance of THintWindow.");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DoActivateHint(
  const TPoint& P, AnsiString TipText)
{
  // compute the tooltip's rect
  const int max_width = 200;
  TRect HintRect =
    HintWindow_->CalcHintRect(
      max_width, TipText, NULL
      );

  // position the tooltip's rect
  OffsetRect(
     static_cast<PRECT>(&HintRect),
     P.x + 10, P.y + 10
     );

  // display the tooltip
  HintWindow_->ActivateHint(
    HintRect, TipText
    );

  // enable the time-out timer
  Timer1->Enabled = true;
  tic_ = 0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DoHideHint()
{
  const HWND hHint = HintWindow_->Handle;
  
  // is the tooltip displayed?
  const bool showing =
    IsWindowVisible(hHint);

  if (showing)
  {
    // hide the tooltip
    ShowWindow(hHint, SW_HIDE);

    // disable the time-out timer
    Timer1->Enabled = false;

    // reset the time-out counter
    tic_ = 0;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  ListBox1MouseMove(TObject *Sender,
    TShiftState Shift, int X, int Y)
{
  // find the item that's hit, if any
  const TPoint PMouse = Point(X, Y);
  const int current_index =
    ListBox1->ItemAtPos(PMouse, true);

  // if an item is and it's not the
  // last item that was hit...
  if (current_index != last_index_ &&
      current_index != -1)
  {
    // display the tooltip
    DoActivateHint(
      ListBox1->ClientToScreen(PMouse),
      HintList_->Strings[current_index]
      );
  }
  else if (current_index == -1)
  {
    // dismiss the tooltip
    DoHideHint();
  }
  
  // update the last index
  last_index_ = current_index;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  ListBox1MouseDown(TObject *Sender,
    TMouseButton Button,
    TShiftState Shift, int X, int Y)
{
  // dismiss the tooltip
  DoHideHint();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  Timer1Timer(TObject *Sender)
{
  // time-out counting...
  if (++tic_ > MAXTIC)
  {
    DoHideHint();
  }
  // cursor position checking...
  else
  {
    // extract the position of the cursor
    POINT PMouse = {0};
    GetCursorPos(&PMouse);

    // grab the screen-relative position
    // of the target control
    RECT RListBox = {0};
    GetWindowRect(
      ListBox1->Handle, &RListBox);

    // if the mouse cursor is beyond
    // the bounds of the list box...
    if (!PtInRect(&RListBox, PMouse))
    {
      // clear the last index
      last_index_ = -1;
      
      // dismiss the tooltip
      DoHideHint();
    }
  }
}
//---------------------------------------------------------------------------


