
//---------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "BitmapHintWindow.h"
//---------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------

__fastcall TBitmapHintWindow::TBitmapHintWindow(TComponent* AOwner)
   : THintWindow(AOwner)
{
   Image_ = new TImage(this);
   Image_->Parent = this;
   Image_->AutoSize = true;
   Image_->Left = 1;
   Image_->Top = 1;

   // supress the Image from processing mouse messages
   Image_->Enabled = false;

   // eliminate unnecessary erasing
   Brush->Style = bsClear;
}
//---------------------------------------------------------------------

TRect __fastcall TBitmapHintWindow::CalcHintRect(int MaxWidth,
   const AnsiString AHint, void* AData)
{
   // update the image
   TGraphic* Graphic = static_cast<TGraphic*>(AData);
   DoSetGraphic(Graphic);

   // get the default rectangle
   TRect HintRect = THintWindow::CalcHintRect(
      MaxWidth, AHint, AData
      );

   // make room for the image
   HintRect.Right += Image_->Width + 4;
   HintRect.Bottom = max(
      static_cast<int>(HintRect.Bottom),
      Image_->Height + 4
      );

   HintRect.bottom -= 4; // increased by 4 in parent class
   return HintRect;
}
//---------------------------------------------------------------------

void __fastcall TBitmapHintWindow::ActivateHint(const TRect &Rect,
   const AnsiString AHint)
{
   THintWindow::ActivateHint(Rect, AHint);
}
//---------------------------------------------------------------------

void __fastcall TBitmapHintWindow::Paint()
{
   // compute the destination rectangle
   RECT RText = {
      Image_->Width + 4, 0, ClientWidth, ClientHeight
      };
   DrawText(
      Canvas->Handle, Caption.c_str(), -1, &RText,
      DT_CALCRECT | DT_CENTER | DT_NOPREFIX | DT_WORDBREAK
      );

   // center the text vertically      
   const int text_height = RText.bottom - RText.top;
   RText.top = 0.5 * (ClientHeight - text_height);
   RText.bottom += RText.top;

   // render the text
   DrawText(
      Canvas->Handle, Caption.c_str(), -1, &RText,
      DT_CENTER | DT_NOPREFIX | DT_WORDBREAK
      );
}
//---------------------------------------------------------------------

