
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(
  TComponent* Owner) : TForm(Owner),
  last_node_(NULL)
{
  HintWindow_ = new TImageHintWindow(this);
  HintWindow_->Brush->Color = clWindow;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DoActivateHint(
  const TPoint& P)
{
  // compute the tooltip's rect
  TRect HintRect =
    HintWindow_->CalcHintRect(
      0, NULL, NULL
      );

  // position the tooltip's rect
  OffsetRect(
     static_cast<PRECT>(&HintRect),
     P.x + 10, P.y + 10
     );

  // display the tooltip
  HintWindow_->ActivateHint(
    HintRect, NULL
    );

  // reset the time-out counter
  tic_ = 0;

  // enable the time-out timer
  Timer1->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DoHideHint()
{
  const HWND hHint = HintWindow_->Handle;
  
  // is the tooltip displayed?
  const bool showing =
    IsWindowVisible(hHint);
    
  if (showing)
  {
    // hide the tooltip
    ShowWindow(hHint, SW_HIDE);

    // disable the time-out timer
    Timer1->Enabled = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  TreeView1MouseMove(TObject *Sender,
    TShiftState Shift, int X, int Y)
{
  // find the node that's hit, if any
  TTreeNode* current_node =
    TreeView1->GetNodeAt(X, Y);

  // if a node is hit and it's not the
  // last node that was hit and it's
  // not a child node...
  if (current_node &&
      current_node != last_node_ &&
      current_node->Level == 0)
  {
    // set the image to display
    HintImageList->GetBitmap(
      current_node->Index,
      HintWindow_->Image->Picture->Bitmap
      );

    // display the tooltip
    DoActivateHint(TreeView1->
      ClientToScreen(Point(X, Y))
      );
  }
  else if (!current_node ||
           current_node->Level > 0)
  {
    // dismiss the tooltip
    DoHideHint();
  }
  
  // update the last node
  last_node_ = current_node;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  TreeView1MouseDown(TObject *Sender,
    TMouseButton Button,
    TShiftState Shift, int X, int Y)
{
  // dismiss the tooltip
  DoHideHint();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  Timer1Timer(TObject *Sender)
{
  // time-out counting...
  if (++tic_ > MAXTIC)
  {
    DoHideHint();
  }
  // cursor position checking...
  else
  {
    // extract the position of the cursor
    POINT PMouse = {0};
    GetCursorPos(&PMouse);

    // grab the screen-relative position
    // of the target control
    RECT RTreeView = {0};
    GetWindowRect(
      TreeView1->Handle, &RTreeView
      );

    // if the mouse cursor is beyond
    // the bounds of the tree view...
    if (!PtInRect(&RTreeView, PMouse))
    {
      // clear the last node
      last_node_ = NULL;
      
      // dismiss the tooltip
      DoHideHint();
    }
  }
}
//---------------------------------------------------------------------------



