//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ListDemoMain.h"
#include "ListManager.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

// 'Item' class that represents an item in the listview. The
// class must implement the following functions:
//   GetColumnString(int iColumn)
//   GetImageIndex()

class Contact
{
  protected:
  AnsiString sName;
  AnsiString sContact;
  AnsiString sAddress;
  AnsiString sState;
  AnsiString sZip;

  public:

  // Constructor
  Contact(AnsiString name, AnsiString contact, AnsiString address,
          AnsiString state, AnsiString zip);

  AnsiString GetColumnString(int iColumn);
  int GetImageIndex();
};
#define ICON_PERSON  0
#define ICON_CONTACT 1

Contact::Contact(AnsiString name, AnsiString contact, AnsiString address,
                 AnsiString state, AnsiString zip)
{
  sName = name;
  sContact = contact;
  sAddress = address;
  sState = state;
  sZip = zip;
}

// This function is called to get the string data to be
// displayed in the listview columns.
AnsiString Contact::GetColumnString(int iColumn)
{
  switch (iColumn) {
    case 0: return sName;
    case 1: return sContact;
    case 2: return sAddress;
    case 3: return sState;
    case 4: return sZip;
  }
  return "";
}

// This function is called to get the item's icon
int Contact::GetImageIndex()
{
  if (sContact.Length() > 0) {
    return ICON_CONTACT;
  }
  return ICON_PERSON;
}


// ==========================================================================
// TListDemoForm
// ==========================================================================
TListDemoForm *ListDemoForm;
//---------------------------------------------------------------------------
__fastcall TListDemoForm::TListDemoForm(TComponent* Owner)
  : TForm(Owner)
{
  ListViewManager<Contact> *mgr = new ListViewManager<Contact>(lvContacts);
  mgr->AddObject(new Contact("Jack Brown", "", "123 Main St", "CA", "91505"));
  mgr->AddObject(new Contact("Muscle Motors", "Bob Falfa", "246 Road Way", "CA", "94536"));
  mgr->AddObject(new Contact("Ruth Greene", "", "314 East Marengo", "CA", "91101"));
}
//---------------------------------------------------------------------------
void __fastcall TListDemoForm::btnExitClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

