#include <vcl.h>
#pragma hdrstop

#include <Registry.hpp>
#include "MainU.h"

#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;

__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
}

void __fastcall
TMainForm::WriteBtnClick(TObject *Sender)
{
  // Show the Font dialog.
  if (FontDialog1->Execute()) {
    LOGFONT lf;
    // Create a TRegistry object.
    TRegistry* reg = new TRegistry;
    try {
      // Open a key in the registry. Create
      // the key if it doesn't yet exist.
      reg->OpenKey("\\software\\test", true);
      // Put the font data in a LOGFONT structure.
      GetObject(FontDialog1->Font->Handle,
        sizeof(lf), &lf);
      // Write the data to the registry.
      reg->WriteBinaryData(
        "font", &lf, sizeof(lf));
      ShowMessage("Registry key created.");
    }
    __finally {
      // Clean up.
      delete reg;
    }
  }
}

void __fastcall
TMainForm::ReadBtnClick(TObject *Sender)
{
  LOGFONT lf;
  // Create a TRegistry object.
  TRegistry* reg = new TRegistry;
  try {
    // Open the key created earlier.
    reg->OpenKey("\\software\\test", false);
    // Read the data directly into the
    // LOGFONT variable, lf.
    reg->ReadBinaryData("font", &lf, sizeof(lf));
    // Create a font from the LOGFONT data and
    // assign it to the label's Handle property.
    Label1->Font->Handle = CreateFontIndirect(&lf);
  }
  __finally {
    // Clean up.
    delete reg;
  }
}

