//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "MainU.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
#include <algorith>
TMainForm *MainForm;
std::vector<Card*> FullDeck(52);
std::vector<Card*> Deck(52);

__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
}

void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  randomize();
  HumanWinCount = 0;
  ComputerWinCount = 0;
  NumDecks = 6;
  int cardsInst = (int)LoadLibrary("cards2.dll");
  if (!cardsInst) {
    ShowMessage("failed to load cards2.dll");
    Application->Terminate();
    return;
  }
  Graphics::TBitmap* bm;
  for (int i=1;i<55;i++) {
    bm = new Graphics::TBitmap;
    bm->LoadFromResourceID(cardsInst, i);
    ImageList1->AddMasked(bm, clOlive);
    delete bm;
  }
  FreeLibrary((void*)cardsInst);
  DeckXPos = 500;
  DeckYPos = (Height/2) - (ImageList1->Height/2);
  Human = new Player;
  Computer = new Player;
}

void __fastcall TMainForm::FormMouseDown(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
  // Find out which card was clicked.
  int pixel = int(Canvas->Pixels[X][Y]);
  if (Y > 116 || Y < 20 || pixel == 33280)
    return;
  DragCard = ((X + 45) / 71) - 1;
  int x = 20 + (DragCard * 71) + (DragCard * 20);
  ImageList1->SetDragImage(
    Human->GetCard(DragCard)->Index, X, Y);
  HotSpotX = X;
  HotSpotY = Y;
  ImageList1->BeginDrag(Handle, X + x, Y + 20);
  Dragging = true;
  // Clear the spot where the card was.
  //Canvas->Pen->Color = Color;
  //Canvas->Brush->Color = Color;
  //Canvas->Rectangle(100, 20, 100 + 71, 20 + 96);
}

void __fastcall TMainForm::FormMouseMove(TObject *Sender, TShiftState Shift,
      int X, int Y)
{
  if (Dragging)
    ImageList1->DragMove(X, Y);
    //ImageList1->DragMove(HotSpotX + X, HotSpotY + Y);
}

void __fastcall TMainForm::FormMouseUp(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
  if (Dragging) {
    Dragging = false;
    ImageList1->EndDrag();
  }
}

void TMainForm::Shuffle()
{
  Deck.clear();
  Human->ClearCards();
  Computer->ClearCards();
  LastCard = 0;
  for (int j=0;j<NumDecks;j++) {
    FullDeck.clear();
    for (int i=0;i<13;i++) {
      Card* card = new Card;
      if (i < 10)
        card->Value = i + 1;
      else
        card->Value = 10;
      card->Index = i;
      FullDeck.push_back(card);
    }
    for (int i=0;i<13;i++) {
      Card* card = new Card;
      if (i < 10)
        card->Value = i + 1;
      else
        card->Value = 10;
      card->Index = i + 13;
      FullDeck.push_back(card);
    }
    for (int i=0;i<13;i++) {
      Card* card = new Card;
      if (i < 10)
        card->Value = i + 1;
      else
        card->Value = 10;
      card->Index = i + 26;
      FullDeck.push_back(card);
    }
    for (int i=0;i<13;i++) {
      Card* card = new Card;
      if (i < 10)
        card->Value = i + 1;
      else
        card->Value = 10;
      card->Index = i + 39;
      FullDeck.push_back(card);
    }
    while (Deck.size() < (j + 1) * 52) {
      int x = random(52);
      if (FullDeck[x]->Value != -1) {
        Deck.push_back(new Card(FullDeck[x]));
        FullDeck[x]->Value = -1;
      }
      else if (Deck.size() < 35) {
        Sleep(10);
        ImageList1->Draw(Canvas, DeckXPos,
          DeckYPos, Deck[Deck.size() - 1]->Index, true);
      }
    }
  }
  ImageList1->Draw(Canvas,
    DeckXPos, DeckYPos, 53, true);
}

void TMainForm::Animate(Player* player)
{
  int targetY = 20;
  int targetX = 20 + ((player->CardCount() - 1)
     * (ImageList1->Width + 5));
  int y = DeckYPos;
  int x;
  ImageList1->BeginDrag(Handle, DeckXPos, DeckYPos);
  if (player == Human) {
    int steps = (DeckXPos - targetX) / 15;
    int delta = (DeckYPos - targetY) / steps;
    for (x=DeckXPos;x>targetX;x-=15) {
      Application->ProcessMessages();
      y -= delta;
      ImageList1->DragMove(x, y);
    }
    y = targetY;
    x = targetX;
    ImageList1->EndDrag();
    ImageList1->Draw(Canvas, x, y, Deck[LastCard]->Index, true);
  }
  else {
    targetY = 300;
    int steps = (DeckXPos - targetX) / 15;
    int delta = (targetY - DeckYPos) / steps;
    for (x=DeckXPos;x>targetX;x-=15) {
      Application->ProcessMessages();
      y += delta;
      ImageList1->DragMove(x, y);
    }
    ImageList1->EndDrag();
    y = targetY;
    x = targetX;
    if (player->CardCount() == 1)
      ImageList1->Draw(Canvas, x, y, 53, true);
    else
    ImageList1->Draw(Canvas, x, y, Deck[LastCard]->Index, true);
  }
}

void __fastcall TMainForm::Deal1Click(TObject *Sender)
{
  Shuffle();
  Deal();
}

void TMainForm::Deal()
{
  ComputerTotalLbl->Caption = "My total: ";
  HumanTotalLbl->Caption = "Your total: ";
  ScoreLbl->Caption = "You: " + String(HumanWinCount) +
    "  Me: " + String(ComputerWinCount);
  Repaint();
  // Give the human player a card.
  if (LastCard > ((NumDecks * 52) - 6))
    Shuffle();
  Human->AddCard(Deck[LastCard]);
  ImageList1->SetDragImage(Deck[LastCard]->Index, 1, 1);
  Animate(Human);
  LastCard++;
  // Give the computer player a card.
  Computer->AddCard(Deck[LastCard]);
  ImageList1->SetDragImage(53, 1, 1);
  Animate(Computer);
  LastCard++;
  // Give the human player a second card.
  Human->AddCard(Deck[LastCard]);
  ImageList1->SetDragImage(Deck[LastCard]->Index, 1, 1);
  Animate(Human);
  LastCard++;
  // Give the computer player a second card.
  Computer->AddCard(Deck[LastCard]);
  ImageList1->SetDragImage(Deck[LastCard]->Index, 1, 1);
  Animate(Computer);
  LastCard++;
  HumanTotalLbl->Caption = "Your total: " +
    String(Human->GetTotal());
  HitBtn->Visible = true;
  StayBtn->Visible = true;
  HumanTotalLbl->Visible = true;
  ScoreLbl->Visible = true;
}

void __fastcall TMainForm::FormPaint(TObject *Sender)
{
  // Draw the deck in the middle of the form.
  ImageList1->Draw(Canvas, DeckXPos, DeckYPos, 53, true);
  // Draw human player's cards.
  if (Human->CardCount())
    for (int i=0;i<Human->CardCount();i++)
      ImageList1->Draw(Canvas,
        20 + (i * (ImageList1->Width + 5)), 20,
        Human->GetCard(i)->Index, true);
  if (Computer->CardCount()) {
      ImageList1->Draw(
        Canvas, 20, 300, 53, true);
    for (int i=1;i<Computer->CardCount();i++)
      ImageList1->Draw(Canvas,
        20 + (i * (ImageList1->Width + 5)), 300,
        Computer->GetCard(i)->Index, true);
  }
}

void __fastcall TMainForm::HitBtnClick(TObject *Sender)
{
  // Give the human player a card.
  Human->AddCard(Deck[LastCard]);
  ImageList1->SetDragImage(Deck[LastCard]->Index, 1, 1);
  Animate(Human);
  LastCard++;
  HumanTotalLbl->Caption = "Your total: " +
    String(Human->GetTotal());
  if (Human->GetTotal() > 21) {
    ShowMessage("You lose!");
    HitBtn->Enabled = true;
    Human->ClearCards();
    Computer->ClearCards();
    Deal();
    ComputerWinCount++;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::StayBtnClick(TObject *Sender)
{
  HitBtn->Enabled = false;
  ComputerTotalLbl->Visible = true;
  // Show the card that was hidden.
  ImageList1->Draw(Canvas, 20, 300,
    Computer->GetCard(0)->Index, true);
  int total = Computer->GetTotal();
  ComputerTotalLbl->Caption = "My total: " +
    String(total);
  ComputerTotalLbl->Update();
  while (total < 14) {
    Sleep(1000);
    // Dealer has to take a card.
    Computer->AddCard(Deck[LastCard]);
    ImageList1->SetDragImage(Deck[LastCard]->Index, 1, 1);
    Animate(Computer);
    LastCard++;
    total = Computer->GetTotal();
    ComputerTotalLbl->Caption = "My total: " +
      String(total);
    ComputerTotalLbl->Update();
  }
  if (total > 21 || (total <= Human->GetTotal())) {
    ShowMessage("You win!");
    HumanWinCount++;
  }
  else {
    ShowMessage("You lose!");
    ComputerWinCount++;
  }
  HitBtn->Enabled = true;
  Human->ClearCards();
  Computer->ClearCards();
  Deal();
}
//---------------------------------------------------------------------------

