//---------------------------------------------------------------------------
#ifndef MainUH
#define MainUH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ImgList.hpp>
#include <Menus.hpp>
#include <stack>
#include <vector>
//---------------------------------------------------------------------------
class Card {
  public:
    int Index;
    int Value;
    Card() {
      Index = 0;
      Value = 0;
    }
    Card(Card* c) {
      Index = c->Index;
      Value = c->Value;
    }
};

class Player {
  private:
    std::vector<Card*> Cards;
  public:
    void AddCard(Card* card) { Cards.push_back(card); }
    int CardCount() { return Cards.size(); }
    void ClearCards() { Cards.clear(); }
    int GetTotal() {
      int total = 0;
      bool hasAce = false;
      for (int i=0;i<Cards.size();i++) {
        if (Cards[i]->Value == 1) {
          hasAce = true;
          total += 11;
        }
        else
          total += Cards[i]->Value;
      }
      if (total > 21 && hasAce) {
        total = 0;
        for (int i=0;i<Cards.size();i++)
          total += Cards[i]->Value;
      }
      return total;
    }
    Card* GetCard(int index) { return Cards[index]; }
    Player() : Cards(10) { Cards.clear(); }
    ~Player() { Cards.clear(); }
};

class TMainForm : public TForm
{
__published:	// IDE-managed Components
  TImageList *ImageList1;
  TMainMenu *MainMenu1;
  TMenuItem *Play1;
  TMenuItem *Deal1;
  TButton *HitBtn;
  TButton *StayBtn;
  TLabel *HumanTotalLbl;
  TLabel *ComputerTotalLbl;
  TLabel *ScoreLbl;
  void __fastcall FormMouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall FormMouseMove(TObject *Sender, TShiftState Shift, int X,
          int Y);
  void __fastcall FormMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall Deal1Click(TObject *Sender);
  void __fastcall FormPaint(TObject *Sender);
  void __fastcall HitBtnClick(TObject *Sender);
  void __fastcall StayBtnClick(TObject *Sender);
private:	// User declarations
  Player* Human;
  Player* Computer;
  bool Dragging;
  int DragCard;
  int HotSpotX;
  int HotSpotY;
  int NumDecks;
  int HumanWinCount;
  int ComputerWinCount;
  void Animate(Player* player);
  void Shuffle();
  void Deal();
  int LastCard;
  int DeckXPos;
  int DeckYPos;
public:		// User declarations
  __fastcall TMainForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
