//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <shellapi.h>
#include "MainU.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

int MessageDlgCaption(const AnsiString Caption, const AnsiString Msg,
  TMsgDlgType DlgType, TMsgDlgButtons Buttons)
{
  TForm* dlg = CreateMessageDialog(Msg, DlgType, Buttons);
  if (Caption != "") {
    dlg->Caption = Caption;
  }
  return dlg->ShowModal();
}

void ShowMessageCaptionBtn(const AnsiString Caption, const AnsiString Msg, TMsgDlgBtn Btn)
{
  TForm* dlg = CreateMessageDialog(Msg, mtCustom, TMsgDlgButtons() << Btn);
  if (Caption != "") {
    dlg->Caption = Caption;
  }
  dlg->ShowModal();
}

int MessageDlgIcon(const AnsiString Caption, const AnsiString Msg, TIcon* Icon,
  TMsgDlgType DlgType, TMsgDlgButtons Buttons)
{
  TForm* dlg = 
    CreateMessageDialog(Msg, DlgType, Buttons);
  if (Caption != "") 
    dlg->Caption = Caption;
  if (Icon) {
    TImage* image = dynamic_cast<TImage *>
      (dlg->FindComponent("Image"));
    if (image)
      image->Picture->Icon = Icon;
  }
  return dlg->ShowModal();
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TForm* Dlg = CreateMessageDialog("Purge Warp Core?", mtConfirmation,
    TMsgDlgButtons() << mbYes << mbNo);

  TButton* yb = dynamic_cast<TButton *>(Dlg->FindComponent("Yes"));
  yb->Caption = "Affirmative";

  TButton* nb = dynamic_cast<TButton *>(Dlg->FindComponent("No"));
  nb->Caption = "Negative";

  int Rslt = Dlg->ShowModal();

  switch (Rslt) {
    case mrYes:     ;//{ do "Yes" stuff };
    case mrNo:      ;//{ do "No" stuff };
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  TForm* Dlg = CreateMessageDialog("My Message", mtConfirmation,  TMsgDlgButtons() << mbYes << mbNo << mbAll);

  // change the caption
  Dlg->Caption = "Please Confirm";

  // shift the position
  Dlg->Top =+ 300;
  Dlg->Left =+ 300;

  // Get the button instances
  TButton* yb = dynamic_cast<TButton *>(Dlg->FindComponent("Yes"));
  TButton* nb = dynamic_cast<TButton *>(Dlg->FindComponent("No"));
  TButton* ab = dynamic_cast<TButton *>(Dlg->FindComponent("All"));

  // change the button texts
  yb->Caption = "Indeed!";
  nb->Caption = "Surely Not!";
  ab->Caption = "All Please!";

  // change the button fonts
  yb->Font->Name = "Times New Roman";
  nb->Font->Name = "Arial";
  ab->Font->Name = "Courier New";

  // change the Message's appearance
  TLabel* lb = dynamic_cast<TLabel *>(Dlg->FindComponent("Message"));
  lb->Font->Name = "Courier New";
  lb->Font->Size = 16;
  lb->Font->Color = clRed;

  // supply a custom icon
  TImage* img = dynamic_cast<TImage *>(Dlg->FindComponent("Image"));
  img->Picture->Icon->Handle =
    ExtractIcon(HInstance,"C:\\WINNT\\NOTEPAD.EXE", 0);

  // change its position
  img->Left = 200;
  img->Top = 15;

  int Rslt = Dlg->ShowModal();

  switch (Rslt) {
    case mrYes:     ;//{ do "Yes" stuff };
    case mrNo:      ;//{ do "No" stuff };
    case mrAll:     ;//{ do "No to All" stuff };
  }

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
  MessageDlgCaption("Inquiry", "Keep Going?", mtWarning,
    TMsgDlgButtons() << mbOK << mbCancel);

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button4Click(TObject *Sender)
{
  ShowMessageCaptionBtn("Today's Motivational Message",
    "If at first you don't succeed...", mbRetry);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button5Click(TObject *Sender)
{
  TIcon* I = new TIcon;
  I->LoadFromFile("CHEMICAL.ICO");
  MessageDlgIcon("URGENT!", "Unstable Chemical "
   "Reaction Immanent\nCall the fire department!",
   I, mtWarning, 
   TMsgDlgButtons() << mbOK << mbCancel);
}
//---------------------------------------------------------------------------
