
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <memory>
#include <printers.hpp>
#include "bitmapprinter.h"
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
   : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::LoadButtonClick(TObject *Sender)
{
   if (OpenDialog1->Execute())
   {
      // load the image from a file
      Image1->Picture->Bitmap->LoadFromFile(
         OpenDialog1->FileName
         );
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PrintButtonClick(TObject *Sender)
{
   if (PrintDialog1->Execute())
   {
      // create a new TBitmapPrinter object
      std::auto_ptr<TBitmapPrinter>
         BitmapPrinter(new TBitmapPrinter());

      // 24-bpp bitmaps are the safest
      Image1->Picture->Bitmap->PixelFormat = pf24bit;
      BitmapPrinter->Bitmap = Image1->Picture->Bitmap;

      const int index = RadioGroup1->ItemIndex;
      switch (index)
      {
         case bpsHorz: // fit horizontally 
         case bpsVert: // fit vertically
         case bpsPage: // fit to page
         {
            BitmapPrinter->PrintScale =
               static_cast<TBitmapPrinterScale>(index);
            break;
         }
         case bpsCustom: // user-defined rectangle
         {
            // for example...
            RECT RPrint = {
               10, 10,
               Printer()->PageWidth / 2.0,
               Printer()->PageHeight / 3.0
               };
            BitmapPrinter->PrintRect = RPrint;
            break;
         }
      }

      Printer()->BeginDoc();
      try
      {
         // print the bitmap
         BitmapPrinter->PrintBitmap(Printer()->Canvas->Handle);
      }
      catch (...)
      {
         Printer()->EndDoc();
         throw;
      }
      Printer()->EndDoc();      
   }   
}
//---------------------------------------------------------------------------

