#include <vcl.h>
#pragma hdrstop

#include "Main.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TStatusBarForm *StatusBarForm;


__fastcall TStatusBarForm::TStatusBarForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;
   }
   
void __fastcall TStatusBarForm::StatusBarResize(TObject *Sender)
   {
   if (RightAlignChk->Checked)
      {
      int width = 0;

      for (int i = 1; i < StatusBar->Panels->Count; i++)
         width += StatusBar->Panels->Items[i]->Width;

      StatusBar->Panels->Items[0]->Width = StatusBar->ClientWidth - width;
      }
   else
      {
      StatusBar->Panels->Items[0]->Width = 150;
      }
   }

void __fastcall TStatusBarForm::StatusBarDrawPanel(TStatusBar *StatusBar,
   TStatusPanel *Panel, const TRect &Rect)
   {
   StatusBar->Canvas->Brush->Color = WarningChk->Checked ? clRed : clGreen;
   StatusBar->Canvas->FillRect(Rect);
   }

void __fastcall TStatusBarForm::WarningChkClick(TObject *Sender)
   {
   StatusBar->Repaint();
   }

void __fastcall TStatusBarForm::AutoHintChkClick(TObject *Sender)
   {
   StatusBar->AutoHint = AutoHintChk->Checked;
   StatusBar->Panels->Items[0]->Text = "";
   }

void __fastcall TStatusBarForm::SimplePanelChkClick(TObject *Sender)
   {
   StatusBar->SimplePanel = SimplePanelChk->Checked;
   }

void __fastcall TStatusBarForm::SizeGripChkClick(TObject *Sender)
   {
   StatusBar->SizeGrip = SizeGripChk->Checked;
   }

void __fastcall TStatusBarForm::RightAlignChkClick(TObject *Sender)
   {
   StatusBarResize(Sender);
   }

