#include <vcl.h>
#include <windows.h>
#pragma hdrstop

#pragma argsused
#include "myhook.h"

const int BuffSize = 50;
const String TempHookFile = "c:\\hook.dat";
HHOOK HKbHook;
HHOOK HShellHook;
char Buffer[BuffSize];
int Index;
TFileStream* FS;

int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
  if (reason == DLL_PROCESS_ATTACH) {
    HKbHook = 0;
    HShellHook = 0;
    Index = 0;
  }
  return 1;
}

// NOTE: This example uses a file stream to
// save and restore the DLL's global data. It
// would be better to use a memory mapped file
// for this purpose but use of a memory mapped
// file is beyond the scope of this article.

// The keyboard hook procedure.
LRESULT CALLBACK MyKBHook(int Code,
  WPARAM wParam, LPARAM lParam)
{
  // if (HKbHook is 0 it means that a new
  // process has attached to the hook DLL.
  // We must load the HKbHook value from
  // the temp file so that we can pass it
  // in CallNextHookEx.
  if (HKbHook == 0) {
    FS = new TFileStream(
      TempHookFile, fmOpenRead);
    FS->Read(HKbHook, sizeof(HKbHook));
    FS->Read(HShellHook, sizeof(HShellHook));
    delete FS;
  }
  // if (Code < 0, call the next hook and exit.
  if (Code >= 0)
    // Key up messages only
    if ((lParam & 0x80000000) == 0x80000000)
    {
      // Save the keystroke in the buffer and
      // increment the buffer index variable.
      Buffer[Index] = char(wParam);
      Index++;
      if (Index >= BuffSize) {
        // Buffer is full. Reset the buffer
        // index variable and show the buffer.
        Index = 0;
        MessageBox(0, Buffer, "Hook Message", 0);
      }
    }
  // Call the next hook in the chain.
  return CallNextHookEx(
    HKbHook, Code, wParam, lParam);
}

// The shell hook procedure.
int __stdcall MyShellHook(int Code,
  WPARAM wParam, LPARAM lParam)
{
  // if (HShellHook is 0 it means that a new
  // process has attached to the hook DLL.
  // We must load the HKbHook value from
  // the temp file so that we can pass it
  // in CallNextHookEx.
  if (HShellHook == 0) {
    FS = new TFileStream(
      TempHookFile, fmOpenRead);
    FS->Read(HKbHook, sizeof(HKbHook));
    FS->Read(HShellHook, sizeof(HShellHook));
    delete FS;
  }
  // Only interested in those case where a
  // window is created or destroyed.
  char buff[255];
  if ((Code == HSHELL_WINDOWCREATED) ||
     (Code == HSHELL_WINDOWDESTROYED)) {
    // Get the class name of the window.
    GetClassName((HWND)wParam, buff, sizeof(buff));
    // if (class name is Notepad then let
    // the show a message box.
    String S;
    if (!strcmp(buff, "Notepad")) {
      if (Code == HSHELL_WINDOWCREATED)
        S = "Notepad Starting!";
      else
        S = "Notepad Shutting Down!";
      MessageBox(0, S.c_str(), "Hook Message", 0);
    }
  }
  // Call the next hook in the chain.
  return CallNextHookEx(
    HShellHook, Code, wParam, lParam);
}

// Exported function that is used to install
// the keyboard hook.
bool DLL_EXP HookKb(DWORD ThreadID)
{
  HKbHook = SetWindowsHookEx(
    WH_KEYBOARD, (HOOKPROC)MyKBHook, HInstance, ThreadID);
  bool Result = Boolean(HKbHook);
  // Save the hook handles to a temporary file
  // so that other processes can have access
  // to those values.
  FS = new TFileStream(
    TempHookFile, fmCreate);
  FS->Write(HKbHook, sizeof(HKbHook));
  FS->Write(HShellHook, sizeof(HShellHook));
  delete FS;
  return Result;
}

// Exported function that is used to install
// the shell hook.
bool DLL_EXP HookShell()
{
  HShellHook = SetWindowsHookEx(
    WH_SHELL, (HOOKPROC)MyShellHook, HInstance, 0);
  bool Result = Boolean(HShellHook);
  // Save the hook handles to a temporary file
  // so that other processes can have access
  // to those values.
  FS = new TFileStream(
    TempHookFile, fmCreate);
  FS->Write(HKbHook, sizeof(HKbHook));
  FS->Write(HShellHook, sizeof(HShellHook));
  delete FS;
  return Result;
}

// Exported function that uninstalls all hooks.}
bool DLL_EXP Unhook()
{
  bool Result = false;
  if (HKbHook != 0)
    Result = UnhookWindowsHookEx(HKbHook);
  if (HShellHook != 0)
    Result = UnhookWindowsHookEx(HShellHook);
  HKbHook = 0;
  HShellHook = 0;
  // Delete the temporary file.
  DeleteFile(TempHookFile);
  return Result;
}

//---------------------------------------------------------------------------
