
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <memory>
#include <cassert>
#include "Unit_StreamComp.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "Unit_StreamComp"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

int __fastcall SaveComponent(
   AnsiString filename,
   TComponent* Component
  )
{
  assert(Component != NULL);
  assert(Component->Owner != NULL);

  std::auto_ptr<TFileStream> fs(
    new TFileStream(filename, fmCreate)
    );
  std::auto_ptr<TWriter> Writer(
    new TWriter(fs.get(), 4096)
    );

  // specify the Root component
  Writer->Root = Component->Owner;
  // write the component
  Writer->WriteComponent(Component);
  // return the number of bytes written
  return Writer->Position;
}
//---------------------------------------------------------------------------

int __fastcall LoadComponent(
   AnsiString filename,
   TComponent*& Component
  )
{
  assert(Component != NULL);
  assert(Component->Owner != NULL);

  std::auto_ptr<TFileStream> fs(
    new TFileStream(filename, fmOpenRead)
    );
  std::auto_ptr<TReader> Reader(
    new TReader(fs.get(), 4096)
    );

  // set Root, Owner, and Parent
  Reader->Root = Component->Owner;
  Reader->Owner = Component->Owner;
  TControl* Control =
    dynamic_cast<TControl*>(Component);
  if (Control) {
    Reader->Parent = Control->Parent;
  }

  // remove the existing component
  delete Component; Component = NULL;

  // load the stored component
  Reader->BeginReferences();
  try {
    Component =
      Reader->ReadComponent(NULL);
  }
  __finally {
    Reader->FixupReferences();
    Reader->EndReferences();
  }

  // return the number of bytes read
  return Reader->Position;
}
//---------------------------------------------------------------------------

void RegisterOwnedComponents(
   TComponent& Component
  )
{
  const int count =
    Component.ComponentCount;
  for (int idx = 0; idx < count; ++idx)
  {
    TComponent& OwnedComponent =
      *Component.Components[idx];
    const TComponentClass classes[1] =
      {OwnedComponent.ClassType()};

    // register OwnedComponent
    RegisterClasses(classes, 0);

    // recursively register all of
    // OwnedComponent's components
    RegisterOwnedComponents(
      OwnedComponent);
  }
}
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SaveButtonClick(TObject *Sender)
{
  if (SaveDialog1->Execute())
  {
    const int num_wrote = SaveComponent(
      SaveDialog1->FileName, PageControl1
      );
    Memo1->Lines->Add("Saved " + IntToStr(num_wrote) + " bytes.");
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::OpenButtonClick(TObject *Sender)
{
  if (OpenDialog1->Execute())
  {
    RegisterOwnedComponents(*this);
    const int num_read = LoadComponent(
      OpenDialog1->FileName,
      static_cast<TComponent*>(PageControl1)
      );
    Memo1->Lines->Add("Loaded " + IntToStr(num_read) + " bytes.");
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
  ProgressBar1->Position = TrackBar1->Position;  
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ScrollBarsChange(TObject *Sender)
{
  Panel2->Color = static_cast<TColor>(RGB(
    ScrollBar1->Position,
    ScrollBar2->Position,
    ScrollBar3->Position
    ));
}
//---------------------------------------------------------------------------

