
//---------------------------------------------------------------------------
#ifndef Unit1_ToolBarH
#define Unit1_ToolBarH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <ImgList.hpp>
#include <Menus.hpp>
#include <ExtCtrls.hpp>
#include <ActnList.hpp>
#include <Dialogs.hpp>

#include <memory>
#include <cassert>
//---------------------------------------------------------------------------

static const TCursor crTBDropAdd = 1;
static const TCursor crTBDropMove = 2;
static const TCursor crTBDropRemove = 3;

class TDragTBObject : public TDragControlObject
{
public:
  __fastcall TDragTBObject(TControl* Control)
    : TDragControlObject(Control) {}

protected:
  virtual TCursor __fastcall
    GetDragCursor(bool Accepted, int X, int Y)
    {
      if (Accepted)
      {
        return dynamic_cast<TToolButton*>(Control) ?
          crTBDropMove : crTBDropAdd;
      }
      return crTBDropRemove;
    }
  virtual TDragImageList* __fastcall GetDragImages()
    {
      return NULL;
    }
};
//---------------------------------------------------------------------------

class TForm1 : public TForm
{
__published:
  TCoolBar *CoolBar1;
  TToolBar *FileToolBar;
  TToolBar *EditToolBar;
  TToolBar *FrmtToolBar;
  TToolBar *ViewToolBar;

  TPopupMenu *TBPopupMenu;
  TImageList *TBImageList;
  TSaveDialog *TBSaveDialog;
  TOpenDialog *TBOpenDialog;
  
  TMenuItem *N1; // divider
  TMenuItem *N2; // divider
  TMenuItem *FileMenuItem;
  TMenuItem *EditMenuItem;
  TMenuItem *ViewMenuItem;
  TMenuItem *FrmtMenuItem;
  TMenuItem *LoadMenuItem;
  TMenuItem *SaveMenuItem;
  TMenuItem *CustomizeMenuItem;

  // drag-and-drop support for regular toolbuttons
  void __fastcall ToolBtnsStartDrag(
    TObject *Sender, TDragObject *&DragObject);
  void __fastcall ToolBtnsEndDrag(
    TObject *Sender, TObject *Target, int X, int Y);
  void __fastcall ToolBtnsDragOver(
    TObject *Sender, TObject *Source,
    int X, int Y, TDragState State, bool &Accept);
  void __fastcall ToolBtnsDragDrop(
    TObject *Sender, TObject *Source, int X, int Y);

  // drag-and-drop support for separator toolbuttons    
  void __fastcall ToolBarsMouseDown(
    TObject *Sender, TMouseButton Button,
    TShiftState Shift, int X, int Y);
  void __fastcall ToolBarsDragOver(
    TObject *Sender, TObject *Source, int X, int Y,
    TDragState State, bool &Accept);
  void __fastcall ToolBarsDragDrop(
    TObject *Sender, TObject *Source, int X, int Y);

  // TBPopupMenu event handlers
  void __fastcall TBPopupMenuPopup(
    TObject *Sender);
  void __fastcall TBMenuItemsClick(
    TObject *Sender);
  void __fastcall LoadMenuItemClick(
    TObject *Sender);
  void __fastcall SaveMenuItemClick(
    TObject *Sender);
  void __fastcall CustomizeMenuItemClick(
    TObject *Sender);

  // toolbuttons OnClick event handler
  void __fastcall ToolBtnsClick(
    TObject *Sender);
  void __fastcall Button1Click(TObject *Sender);

private:
  std::auto_ptr<TDragTBObject>
    DragTBObject_;

  // toolbar utility methods
  void __fastcall CustomizeToolBar(
    TToolBar& ToolBar, bool customize);
  TToolButton* __fastcall NewButton(
    TToolBar& ToolBar, AnsiString caption,
    int image_index);
  void __fastcall DoDrop(
    TToolBar& ToolBar, TToolButton* Btn,
    TControl* SrcCtl, bool after);

  // toolbar streaming methods
  void __fastcall LoadToolBars(AnsiString filename);
  void __fastcall SaveToolBars(AnsiString filename);

public:
  __fastcall TForm1(TComponent* Owner);
  void __fastcall CustomizeMode(bool customize);
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
