
//---------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2_ToolBar.h"
//---------------------------------------------------------------------
#pragma resource "*.dfm"
TCustomizeDlg *CustomizeDlg;
//---------------------------------------------------------------------

__fastcall TCustomizeDlg::TCustomizeDlg(TComponent* AOwner)
	: TForm(AOwner),
  FileTBInfo_(new TStringList()),
  EditTBInfo_(new TStringList()),
  FrmtTBInfo_(new TStringList()),
  ViewTBInfo_(new TStringList()),
  DragTBObject_(
    new TDragTBObject(CommandListView))
{
  const AnsiString filename(
    ExtractFilePath(Application->ExeName) +
    "TOOLBARS.INI"
    );
  assert(FileExists(filename));
  std::auto_ptr<TIniFile> IniFile(new TIniFile(filename));

  // read the captions and image indices for the toolbars
  IniFile->ReadSectionValues("File", FileTBInfo_.get());
  IniFile->ReadSectionValues("Edit", EditTBInfo_.get());
  IniFile->ReadSectionValues("Frmt", FrmtTBInfo_.get());
  IniFile->ReadSectionValues("View", ViewTBInfo_.get());
}
//---------------------------------------------------------------------

void __fastcall TCustomizeDlg::FormClose(
   TObject *Sender, TCloseAction &Action
  )
{
  Form1->CustomizeMode(false);
}
//---------------------------------------------------------------------------

void __fastcall TCustomizeDlg::CategoryListViewChange(
   TObject *Sender, TListItem *Item, TItemChange Change
  )
{
  static TListItem* LastItem = NULL;
  if (Change == ctState && Item->Selected &&
      Item != LastItem)
  {
    LastItem = Item;
    UpdateCommandListView();
  }
}
//---------------------------------------------------------------------------

void __fastcall TCustomizeDlg::UpdateCommandListView()
{
  TListItem* Item = CategoryListView->Selected;
  if (Item == NULL) return;

  TStrings* TBInfo = NULL;
  switch (Item->Index)
  {
    case 0: TBInfo = FileTBInfo_.get(); break;
    case 1: TBInfo = EditTBInfo_.get(); break;
    case 2: TBInfo = FrmtTBInfo_.get(); break;
    case 3: TBInfo = ViewTBInfo_.get(); break;
  }
  assert(TBInfo != NULL);

  CommandListView->Items->BeginUpdate();
  try
  {
    CommandListView->Items->Clear();
    const int count = TBInfo->Count;
    for (int index = 0; index < count; ++index)
    {
      TListItem* NewItem = CommandListView->Items->Add();
      NewItem->Caption = TBInfo->Names[index];
      NewItem->ImageIndex = TBInfo->Values[
        TBInfo->Names[index]].ToInt();
    }
  }
  catch (...)
  {
    CommandListView->Items->EndUpdate();
    throw;
  }
  CommandListView->Items->EndUpdate();
}
//---------------------------------------------------------------------------

void __fastcall TCustomizeDlg::Splitter1Moved(TObject *Sender)
{
  CommandLabel->Left = CommandListView->Left + 1;    
}
//---------------------------------------------------------------------------

void __fastcall TCustomizeDlg::CloseButtonClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TCustomizeDlg::CommandsTabSheetShow(TObject *Sender)
{
  ActiveControl = CategoryListView;
  if (CategoryListView->Selected == NULL)
  {
    CategoryListView->Selected =
      CategoryListView->Items->Item[0];
    CategoryListView->ItemFocused =
      CategoryListView->Items->Item[0];
  }
}
//---------------------------------------------------------------------------

void __fastcall TCustomizeDlg::
  UpdateToolBarsCheckBox()
{
  ToolBarsCheckListBox->Checked[0] =
    Form1->FileToolBar->Visible;
  ToolBarsCheckListBox->Checked[1] =
    Form1->EditToolBar->Visible;
  ToolBarsCheckListBox->Checked[2] =
    Form1->FrmtToolBar->Visible;
  ToolBarsCheckListBox->Checked[3] =
    Form1->ViewToolBar->Visible;
}
//---------------------------------------------------------------------------

void __fastcall TCustomizeDlg::
  ToolBarsCheckListBoxClickCheck(TObject *Sender)
{
  Form1->FileToolBar->Visible =
    ToolBarsCheckListBox->Checked[0];
  Form1->EditToolBar->Visible =
    ToolBarsCheckListBox->Checked[1];
  Form1->FrmtToolBar->Visible =
    ToolBarsCheckListBox->Checked[2];
  Form1->ViewToolBar->Visible =
    ToolBarsCheckListBox->Checked[3];
}
//---------------------------------------------------------------------------

void __fastcall TCustomizeDlg::
  CommandListViewStartDrag(
    TObject *Sender,
    TDragObject *&DragObject
  )
{
  DragObject = DragTBObject_.get();
}
//---------------------------------------------------------------------------



