#include <vcl.h>
#pragma hdrstop

#include <except.h>

#include "Main.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   sortType = 0;
   sortAscending = true;

   Application->OnException = OnException;
   }

void __fastcall TMainForm::CloseBtnClick(TObject *Sender)
   {
   Close();
   }

void __fastcall TMainForm::ZeroBtnClick(TObject *Sender)
   {
   int a = 0, b = 3;
   int c = b / a;
   b = c;
   }

void __fastcall TMainForm::OnException(TObject* sender, Exception* exception)
   {
   Log(exception);

   if (String(exception->ClassName()) == "EDivByZero")
      {
      exception->Message += "\r\n\r\nYou really shouldn't divide by zero!";
      Application->MessageBox(exception->Message.c_str(), "Whoa!", MB_OK | MB_ICONSTOP);
      }
   else
      Application->ShowException(exception);
   }

void __fastcall TMainForm::Log(Exception *exception)
   {
   TListItem *item = LogListView->Items->Add();
   item->Caption = Now().DateTimeString();

   item->SubItems->Add(exception->ClassName());
   item->SubItems->Add(exception->Message);
   }

void __fastcall TMainForm::BaseBtnClick(TObject *Sender)
   {
   throw Exception("This is a plain, base class Exception.");
   }

void __fastcall TMainForm::LogListViewColumnClick(TObject *Sender, TListColumn *Column)
   {
   if (sortType == Column->Tag)
      sortAscending = !sortAscending;
   else
      {
      sortAscending = true;
      sortType = Column->Tag;
      }

   LogListView->AlphaSort();
   }

void __fastcall TMainForm::LogListViewCompare(TObject *Sender, TListItem *Item1, TListItem *Item2,
   int Data, int &Compare)
   {
   int sortDir = sortAscending ? 1 : -1;

   TDateTime d1(Item1->Caption);
   TDateTime d2(Item2->Caption);
   int cd = d1 < d2 ? - 1 : d1 > d2 ? 2 : 0;

   switch (sortType)
      {
      case 0:
         Compare = cd;
         break;
      case 1:
         {
         int c = CompareText(Item1->SubItems->Strings[0], Item2->SubItems->Strings[0]);
         Compare = c == 0 ? cd : c;
         break;
         }
      case 2:
         {
         int c = CompareText(Item1->SubItems->Strings[1], Item2->SubItems->Strings[1]);
         Compare = c == 0 ? cd : c;
         break;
         }
      }

   Compare *= sortDir;
   }

void __fastcall TMainForm::MyBtnClick(TObject *Sender)
   {
   throw EMyException();
   }

void __fastcall TMainForm::NonVCLBtnClick(TObject *Sender)
   {
   throw 12;
   }

void __fastcall TMainForm::AccessBtnClick(TObject *Sender)
   {
   TForm *badPtr = 0;
   badPtr->Close();
   }

