#ifndef MainH
#define MainH

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <AppEvnts.hpp>

class EMyException : public Exception
   {
   public:
      EMyException() : Exception("Custom exception derived from the VCl Exception class.") {}
   };

class TMainForm : public TForm
   {
   __published:
      TLabel *Label1;
      TButton *CloseBtn;
      TGroupBox *GroupBox1;
      TButton *ZeroBtn;
      TButton *BaseBtn;
      TButton *MyBtn;
      TButton *NonVCLBtn;
      TButton *AccessBtn;
      TListView *LogListView;

      void __fastcall CloseBtnClick(TObject *Sender);
      void __fastcall ZeroBtnClick(TObject *Sender);
      void __fastcall BaseBtnClick(TObject *Sender);
      void __fastcall LogListViewColumnClick(TObject *Sender,
             TListColumn *Column);
      void __fastcall LogListViewCompare(TObject *Sender, TListItem *Item1,
             TListItem *Item2, int Data, int &Compare);
      void __fastcall MyBtnClick(TObject *Sender);
      void __fastcall NonVCLBtnClick(TObject *Sender);
      void __fastcall AccessBtnClick(TObject *Sender);

   public:
      __fastcall TMainForm(TComponent* Owner);

   private:
      void __fastcall OnException(TObject* sender, Exception* exception);
      void __fastcall Log(Exception *exception);

      int sortType;
      bool sortAscending;
   };


extern PACKAGE TMainForm *MainForm;


#endif   // MainH
