
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <memory>
#include "ColorPopupFormUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PopupFormUnit"
#pragma resource "*.dfm"
TColorPopupForm *ColorPopupForm;
//---------------------------------------------------------------------------

__fastcall TColorPopupForm::TColorPopupForm(TComponent* Owner)
   : TPopupForm(Owner), current_color_(clBlack)
{
   std::auto_ptr<Graphics::TBitmap> Bitmap(new Graphics::TBitmap());
   Bitmap->Width = 14;
   Bitmap->Height = 14;

   for (int y = 0; y < 5; ++y)
   {
      for (int x = 0; x < 8; ++x)
      {
         TSpeedButton* SpeedButton = new TSpeedButton(this);
         SpeedButton->Parent = this;
         SpeedButton->Flat = true;
         SpeedButton->OnClick = SpeedButtonsClick;
         SpeedButton->GroupIndex = 1;
         SpeedButton->SetBounds(x * 18 + 1, y * 18 + 25, 19, 19);

         const unsigned char r = random(256);
         const unsigned char g = random(256);
         const unsigned char b = random(256);

         SpeedButton->ShowHint = true;
         SpeedButton->Hint = "(" +
            IntToStr(r) + ", " + IntToStr(g) +
            ", " + IntToStr(b) + ")";

         Bitmap->Canvas->Brush->Color =
            static_cast<TColor>(PALETTERGB(r, g, b));
         Bitmap->Canvas->Rectangle(0, 0, 14, 14);
         SpeedButton->Glyph = Bitmap.get();
      }
   }
   AutoButton->OnClick = SpeedButtonsClick;
}
//---------------------------------------------------------------------------

void __fastcall TColorPopupForm::SpeedButtonsClick(TObject* Sender)
{
   const int count = ControlCount;
   for (int index = 0; index < count; ++index)
   {
      TSpeedButton* SpeedButton =
         dynamic_cast<TSpeedButton*>(Controls[index]);
      if (SpeedButton && SpeedButton->Down)
      {
         current_color_ =
            SpeedButton->Glyph->Canvas->Pixels[5][5];
      }
   }   
   SetCaptureControl(NULL);
   Close();
}
//---------------------------------------------------------------------------

void __fastcall TColorPopupForm::ColorDialogButtonClick(TObject *Sender)
{
   SetCaptureControl(NULL);
   Hide();
   ColorDialog1->Execute();
   
   current_color_ = ColorDialog1->Color;
   AutoButton->Glyph->Canvas->Brush->Color = current_color_;
   TRect RFill = Rect(0, 0, 13, 13);
   AutoButton->Glyph->Canvas->FillRect(RFill);

   AutoButton->Down = true;
   Close();
}
//---------------------------------------------------------------------------

void __fastcall TColorPopupForm::ColorDialog1Show(TObject *Sender)
{
   SetWindowPos(
      ColorDialog1->Handle, HWND_TOPMOST,
      0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE
      );   
}
//---------------------------------------------------------------------------

void __fastcall TColorPopupForm::FormShow(TObject *Sender)
{
   Timer1->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TColorPopupForm::FormHide(TObject *Sender)
{
   Timer1->Enabled = false;
}
//---------------------------------------------------------------------------

void __fastcall TColorPopupForm::Timer1Timer(TObject *Sender)
{
   POINT PMouse;
   if (GetCursorPos(&PMouse))
   {
      if (WindowFromPoint(PMouse) == Handle)
      {
         ReleaseCapture();
      }
      else SetCapture(Handle);
   }
}
//---------------------------------------------------------------------------

