
/****************************************************************************\

    Popup Form Demo -- Created by Damon Chandler <dmc27@cornell.edu>

    TODO: Add code to handle the case in which the popup forms will be
          displayed off the edges of the screen; see the docs for the
          GetSystemMetrics() API function (SM_CXSCREEN, SM_CYSCREEN,
          SM_CXVIRTUALSCREEN, SM_CYVIRTUALSCREEN).

\****************************************************************************/

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TVPopupFormUnit.h"
#include "LVPopupFormUnit.h"
#include "ColorPopupFormUnit.h"
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
   : TForm(Owner)
{
   TreeViewPopupForm_ = new TTreeViewPopupForm(this);
   TreeViewPopupForm_->OnClose = TreeViewPopupFormClose;

   ListViewPopupForm_ = new TListViewPopupForm(this);
   ListViewPopupForm_->OnClose = ListViewPopupFormClose;

   ColorPopupForm_ = new TColorPopupForm(this);
   ColorPopupForm_->OnClose = ColorPopupFormClose; 
}
//---------------------------------------------------------------------------


//=~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~=//
//= TreeViewPopupForm_ specific event handlers...               =//
//=~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~=//

void __fastcall TForm1::TreeViewSpeedButtonClick(TObject *Sender)
{
   RECT RPopup;
   if (GetWindowRect(TreeViewPanel->Handle, &RPopup))
   {
      TreeViewEdit->SetFocus();
      TreeViewEdit->SelectAll();
      TreeViewPopupForm_->Left = RPopup.left;
      TreeViewPopupForm_->Top = RPopup.bottom;
      TreeViewPopupForm_->Show();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TreeViewPopupFormClose(TObject* Sender,
   TCloseAction &Action)
{
   TTreeNode* Node = TreeViewPopupForm_->TreeView1->Selected;
   if (Node)
   {
      TreeViewEdit->Text = Node->Text;
      TreeViewEdit->SelectAll();      

      TreeViewImage->Picture = NULL;
      TreeViewPopupForm_->ImageList1->GetBitmap(
         Node->ImageIndex, TreeViewImage->Picture->Bitmap
         );
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TreeViewEditKeyDown(TObject *Sender, WORD &Key,
   TShiftState Shift)
{
   if (TreeViewPopupForm_->Visible)
   {
      SNDMSG(
         TreeViewPopupForm_->ActiveControl->Handle,
         WM_KEYDOWN, Key, 0
         );
      Key = 0;
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TreeViewEditKeyUp(TObject *Sender, WORD &Key,
   TShiftState Shift)
{
   if (TreeViewPopupForm_->Visible)
   {
      SNDMSG(
         TreeViewPopupForm_->ActiveControl->Handle,
         WM_KEYUP, Key, 0
         );
      Key = 0;
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TreeViewEditKeyPress(TObject *Sender, char &Key)
{
   if (Key == '\r' && TreeViewPopupForm_->Visible)
   {
      TreeViewPopupForm_->Close();
      Key = 0;
   }
}
//---------------------------------------------------------------------------



//=~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~=//
//= ListViewPopupForm_ specific event handlers...               =//
//                                                               //
// NOTE:                                                         //
//  The ListViewStatic control doesn't expose the OnKey* events  //
//  so we'll use the Form's OnKey* events instead.  You can      //
//  alternatively subclass the ListViewStatic control or create  //
//  a descendant class that publishes these events.              //
//=~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~=//

void __fastcall TForm1::ListViewSpeedButtonClick(TObject *Sender)
{
   RECT RPopup;
   if (GetWindowRect(ListViewPanel->Handle, &RPopup))
   {
      ActiveControl = ListViewStatic;
      ListViewPopupForm_->Left = RPopup.left;
      ListViewPopupForm_->Top = RPopup.bottom;
      ListViewPopupForm_->Show();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ListViewPopupFormClose(TObject* Sender,
   TCloseAction &Action)
{
   TListItem* Item = ListViewPopupForm_->ListView1->Selected;
   if (Item)
   {
      ListViewStatic->Caption = Item->Caption;

      ListViewImage->Picture = NULL;
      ListViewPopupForm_->ImageList1->GetBitmap(
         Item->ImageIndex, ListViewImage->Picture->Bitmap
         );
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if (GetFocus() == ListViewStatic->Handle &&
       ListViewPopupForm_->Visible)
   {
      SNDMSG(
         ListViewPopupForm_->ActiveControl->Handle,
         WM_KEYDOWN, Key, 0
         );
      Key = 0;
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if (GetFocus() == ListViewStatic->Handle &&
       ListViewPopupForm_->Visible)
   {
      SNDMSG(
         ListViewPopupForm_->ActiveControl->Handle,
         WM_KEYUP, Key, 0
         );
      Key = 0;
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
   if (Key == '\r' && GetFocus() == ListViewStatic->Handle &&
       ListViewPopupForm_->Visible)
   {
      ListViewPopupForm_->Close();
      Key = 0;
   }
}
//---------------------------------------------------------------------------


//=~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~=//
//= ColorPopupForm_ specific event handlers...                  =//
//=~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~=//

void __fastcall TForm1::ColorSpeedButton2Click(TObject *Sender)
{
   RECT RPopup = ColorSpeedButton->BoundsRect;
   RPopup.left += ClientOrigin.x;
   RPopup.bottom += ClientOrigin.y;
   
   ColorPopupForm_->Left = RPopup.left;
   ColorPopupForm_->Top = RPopup.bottom;
   ColorPopupForm_->Show();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ColorPopupFormClose(TObject* Sender,
   TCloseAction &Action)
{
   ColorSpeedButton2->Down = false;

   const TRect RBar = Rect(5, 14, 20, 17);
   ColorSpeedButton->Glyph->Canvas->Brush->Color =
      ColorPopupForm_->GetCurrentColor();
   ColorSpeedButton->Glyph->Canvas->FillRect(RBar);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ColorSpeedButtonClick(TObject *Sender)
{
   Color = ColorPopupForm_->GetCurrentColor();
}
//---------------------------------------------------------------------------

