#include <vcl.h>
#pragma hdrstop

#include "Main.h"
#include "NewWindow.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   Application->OnActivate = ActivateApplication;
   Application->OnDeactivate = DeactivateApplication;

   Screen->OnActiveFormChange = FormChange;
   Screen->OnActiveControlChange = ControlChange;
   }

__fastcall TMainForm::~TMainForm()
   {
   Screen->OnActiveControlChange = 0;
   Screen->OnActiveFormChange = 0;
   
   Application->OnActivate = 0;
   Application->OnDeactivate = 0;
   }

void __fastcall TMainForm::Log(String text)
   {
   if (ShowTimeChk->Checked) text.Insert(Now().DateTimeString() + " - ", 1);
   LogMemo->Lines->Add(text);
   }

void __fastcall TMainForm::CloseBtnClick(TObject *Sender)
   {
   Close();
   }

void __fastcall TMainForm::NewBtnClick(TObject *Sender)
   {
   TSecondaryForm *temp = new TSecondaryForm(this);
   temp->Show();
   }

void __fastcall TMainForm::FormChange(TObject *Sender)
   {
   Log("Form: " + Screen->ActiveForm->Name + " - " + Screen->ActiveForm->Caption);
   }

void __fastcall TMainForm::ControlChange(TObject *Sender)
   {
   Log("Control: " + Screen->ActiveControl->Name);
   }

void __fastcall TMainForm::ActivateApplication(TObject *Sender)
   {
   Log("Activate - " + Application->Title);
   }

void __fastcall TMainForm::DeactivateApplication(TObject *Sender)
   {
   Log("Deactivate - " + Application->Title);
   }

void __fastcall TMainForm::ClearBtnClick(TObject *Sender)
   {
   LogMemo->Clear();
   }

