
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit_Scroll.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

#include <cmath>
inline void IncCoord(
   long& val, float zoom, int N)
{
  if (N == 0) // integer zooming factor
  {
    const int dval =
      0.5 + std::fmod(val, zoom);
    val += (dval == 0) ? 0 : zoom - dval;
    return;
  }

  int i = 0.5 +
    static_cast<int>(val / zoom);
  i = 0.5 + N * static_cast<int>(
    static_cast<float>(i + N) / N
    );
  val = 0.5 + (i * zoom);
}
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

inline void DecCoord(
   long& val, float zoom, int N)
{
  if (val == 0) return;

  if (N == 0) // integer zooming factor
  {
    val -= std::fmod(val, zoom);
    return;
  }

  int i = 0.5 +
    static_cast<int>(val / zoom);
  const float num =
    static_cast<float>(i - N);
  if (num < 0)
  {
    i = -0.5 +
      std::ceil(-0.001 + num / N) * N;
    val = -0.5 + (i * zoom);
  }
  else
  {
    i = 0.5 +
      std::ceil(0.001 + num / N) * N;
    val = 0.5 + (i * zoom);
  }
}
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

inline void AdjustUpdateRect(
  RECT& RUpdate, float zoom, int N,
  int sX, int sY)
{
  long x1 = RUpdate.left + sX;
  long y1 = RUpdate.top + sY;
  long x2 = RUpdate.right + sX;
  long y2 = RUpdate.bottom + sY;

  DecCoord(x1, zoom, N);
  DecCoord(y1, zoom, N);
  IncCoord(x2, zoom, N);
  IncCoord(y2, zoom, N);

  RUpdate.left = x1 - sX;
  RUpdate.top = y1 - sY;
  RUpdate.right = x2 - sX;
  RUpdate.bottom = y2 - sY;
}
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

unsigned char MakeBitmapOptimal(
   Graphics::TBitmap& Bitmap
   )
{
  // will hold a handle to the display-
  // optimal DIB section bitmap
  HBITMAP hDIBSection = NULL;
  // will hold the optimal color-depth
  unsigned char opt_bpp = 0;

  // grab the dimensions of Bitmap and a
  // handle to it's associated memory DC
  const SIZE SBmp =
    {Bitmap.Width, Bitmap.Height};
  const HDC hBmpDC =
    Bitmap.Canvas->Handle;
  
  // allocate memory for a BITMAPINFO
  // (this structure is a DIB w/o its
  // pixels; this structure will be
  // initialized with the optimal format)
  const std::size_t dib_size =
    sizeof(BITMAPINFOHEADER) +
    256 * sizeof(RGBQUAD);
  BITMAPINFO* pDIB =
    reinterpret_cast<BITMAPINFO*>(
      new unsigned char[dib_size]
      );

  // zero-out all fields and then
  // specify the header size
  memset(pDIB, 0, dib_size);
  pDIB->bmiHeader.biSize =
    sizeof(BITMAPINFOHEADER);

  // grab a handle to the screen's DC
  const HDC hScnDC = GetDC(NULL);

  // create a 1x1 DDB which we'll use to
  // determine the format of the device's
  // internal memory surface
  const HBITMAP hDDB =
    CreateCompatibleBitmap(hScnDC, 1, 1);

  // use the DDB and the GetDIBits()
  // function with a NULL lpvBits
  // parameter to query the format of
  // the device-managed surface
  bool got_ok = GetDIBits(
    hScnDC, hDDB, 0, 1, NULL, pDIB,
    DIB_RGB_COLORS
    );
  if (got_ok)
  {
    // get the optimal bitfield info
    // (for 15/16- or 32-bpp bitmaps)
    got_ok = GetDIBits(
      hScnDC, hDDB, 0, 1, NULL, pDIB,
      DIB_RGB_COLORS
      );
  }
  // delete the DDB
  DeleteObject(hDDB);
  
  if (got_ok)
  {
    // get the optimal color-depth
    opt_bpp = pDIB->bmiHeader.biBitCount;

    // set the proper dimensions; create
    // a top-down DIB section by setting
    // the biHeight data member negative
    pDIB->bmiHeader.biWidth = SBmp.cx;
    pDIB->bmiHeader.biHeight = -SBmp.cy;

    // create the optimal DIB section
    // bitmap based on the information
    // in pDIB (which the GetDIBits()
    // calls should have filled in)
    hDIBSection =
      CreateDIBSection(
        hScnDC, pDIB, DIB_RGB_COLORS,
        NULL, NULL, 0
        );
  }
  // release the screen's DC
  ReleaseDC(NULL, hScnDC);

  // free the BITMAPINFO
  delete [] reinterpret_cast
    <unsigned char*>(pDIB);

  //
  // copy (and convert) the pixels of
  // Bitmap to the optimal format DIB
  // section bitmap
  //
  if (hDIBSection != NULL)
  {
    HDC hMemDC = NULL;
    HBITMAP hOldBmp = NULL;
    bool blt_ok = false;
    try
    {
      // associate the DIB section bitmap
      // with a memory DC (for drawing)
      hMemDC = CreateCompatibleDC(NULL);
      hOldBmp = static_cast<HBITMAP>(
        SelectObject(hMemDC, hDIBSection)
        );

      // sync the color tables
      if (opt_bpp <= 8)
      {
        // get Bitmap's color table
        RGBQUAD rgbQ[256];
        UINT num_entries =
          GetDIBColorTable(
            hBmpDC, 0, 256, rgbQ
            );

        // if Bitmap has no color table,
        // let's use its Palette instead
        if (num_entries == 0)
        {
          // grab a handle to Bitmap's
          // logical palette
          const HPALETTE hPal =
            Bitmap.Palette;

          // get the number of Bitmap's
          // palette entries
          num_entries =
            GetPaletteEntries(
              hPal, 0, 0, NULL
              );
              
          // create a LOGPALETTE buffer
          const std::size_t pal_size =
            sizeof(LOGPALETTE) +
            (num_entries - 1) *
            sizeof(PALETTEENTRY);
          LOGPALETTE* pLogPal =
            reinterpret_cast
              <LOGPALETTE*>(
              new unsigned char[pal_size]
              );

          // copy the palette data
          const UINT num_got =
            GetPaletteEntries(
              hPal, 0, num_entries,
              pLogPal->palPalEntry
              );
          for (UINT i=0; i<num_got; ++i)
          {
            rgbQ[i].rgbRed = pLogPal->
              palPalEntry[i].peRed;
            rgbQ[i].rgbGreen = pLogPal->
              palPalEntry[i].peGreen;
            rgbQ[i].rgbBlue = pLogPal->
              palPalEntry[i].peBlue;
          }

          // free the LOGPALETTE buffer
          delete [] reinterpret_cast
            <unsigned char*>(pLogPal);
        }
        if (num_entries > 0)
        {
          // copy the colors in rgbQ to
          // hDIBSection's color table
          SetDIBColorTable(
            hMemDC, 0, num_entries, rgbQ
            );
        }
      }

      // copy and convert the pixels of
      // Bitmap to the DIB section bitmap
      blt_ok = BitBlt(
        hMemDC, 0, 0, SBmp.cx, SBmp.cy,
        Bitmap.Canvas->Handle, 0, 0,
        SRCCOPY
        );

      // assign the optimal DIB section
      // bitmap to Bitmap (the TBitmap
      // object will take ownership)
      if (blt_ok)
      {
        Bitmap.Handle = hDIBSection;
      }
    }
    __finally
    {
      // clean up
      SelectObject(hMemDC, hOldBmp);
      DeleteDC(hMemDC);
      if (!blt_ok)
      {
        DeleteObject(hDIBSection);
      }
    }
  }
  // return the optimal color depth
  return opt_bpp;
}
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^



__fastcall TForm1::TForm1(
  TComponent* Owner) : TForm(Owner),
    Bitmap_(new Graphics::TBitmap()),
    zoom_(5.6)
{
  Canvas->Brush->Style = bsClear;
  Bitmap_->LoadFromFile(
    ExtractFileDir(Application->ExeName)
    + "/my_bitmap.bmp"
    );
  //
  // see the article "Display-optimal DIB
  // section bitmaps" for an explanation
  // of the MakeBitmapOptimal() function
  //
  MakeBitmapOptimal(*Bitmap_);

  // set the scroll bars' ranges
  HorzSB->Max = zoom_ * Bitmap_->Width;
  VertSB->Max = zoom_ * Bitmap_->Height;
}
//---------------------------------------------------------------------------

void __fastcall
  TForm1::FormResize(TObject *Sender)
{
  // set the page sizes
  HorzSB->PageSize = std::min(
    ClientWidth - VertSB->Width,
    HorzSB->Max    
    );
  VertSB->PageSize = std::min(
    ClientHeight - HorzSB->Height,
    VertSB->Max
    );

  // clip the scrolling positions
  HorzSB->Position = std::min(
    HorzSB->Max - HorzSB->PageSize,
    HorzSB->Position
    );
  VertSB->Position = std::min(
    VertSB->Max - VertSB->PageSize,
    VertSB->Position
    );

  // redraw the bitmap
  Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::HorzVertSBScroll(
  TObject *Sender, TScrollCode Code,
  int& ScrollPos)
{
  TScrollBar* SB =
    static_cast<TScrollBar*>(Sender);

  // clip the scrolling position
  ScrollPos = std::min(
    SB->Max - SB->PageSize,
    std::max(0, ScrollPos)
    );

  // comute the amount to scroll by
  const int delta =
    SB->Position - ScrollPos;
  if (delta != 0)
  {
    if (SB == HorzSB)
    {
      // scroll the bitmap horizontally
      ScrollWindowEx(
        WindowHandle, delta, 0, NULL,
        NULL, NULL, NULL, SW_INVALIDATE
        );
    }
    else // SB == VertSB
    {
      // scroll the bitmap vertically
      ScrollWindowEx(
        WindowHandle, 0, delta, NULL,
        NULL, NULL, NULL, SW_INVALIDATE
        );
    }
  }
}
//---------------------------------------------------------------------------

void TForm1::WMPaint(TMessage& Msg)
{
  static PAINTSTRUCT ps;
  const HWND hWnd = WindowHandle;
  hDstDC_ = BeginPaint(hWnd, &ps);
  try
  {
    PaintBitmap(ps.rcPaint);
  }
  __finally
  {
    EndPaint(hWnd, &ps);
  }
}
//---------------------------------------------------------------------------

void TForm1::PaintBitmap(RECT& RUpdate)
{
  // grab the scroll bars' positions
  const int sX = HorzSB->Position;
  const int sY = VertSB->Position;

  // ensure that the coordinates of
  // RUpdate are an integer multiple
  // of the zooming factor
  int N = 10; // because zoom_ = 5.6
  AdjustUpdateRect(
    RUpdate, zoom_, N, sX, sY);

  // destination rectangle
  const RECT RDst = RUpdate;

  // source rectangle
  const RECT RSrc = {
    0.5 + (RUpdate.left + sX) / zoom_,
    0.5 + (RUpdate.top + sY) / zoom_,
    0.5 + (RUpdate.right + sX) / zoom_,
    0.5 + (RUpdate.bottom + sY) / zoom_
    };

  StretchBlt(
    // destination DC
    hDstDC_,
    // destination coordinates
    RDst.left, RDst.top,
    RDst.right - RDst.left,
    RDst.bottom - RDst.top,
    // source DC
    Bitmap_->Canvas->Handle,
    // source coordinates
    RSrc.left, RSrc.top,
    RSrc.right - RSrc.left,
    RSrc.bottom - RSrc.top,
    // ROP3 code
    SRCCOPY
    );
}
//---------------------------------------------------------------------------





