
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit_OptimalDIB.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::
  TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

unsigned char MakeBitmapOptimal(
   Graphics::TBitmap& Bitmap
  )
{
  // will hold a handle to the display-
  // optimal DIB section bitmap
  HBITMAP hDIBSection = NULL;
  // will hold the optimal color-depth
  unsigned char opt_bpp = 0;

  // grab the dimensions of Bitmap and a
  // handle to it's associated memory DC
  const SIZE SBmp =
    {Bitmap.Width, Bitmap.Height};
  const HDC hBmpDC =
    Bitmap.Canvas->Handle;
  
  // allocate memory for a BITMAPINFO
  // (this structure is a DIB w/o its
  // pixels; this structure will be
  // initialized with the optimal format)
  const std::size_t dib_size =
    sizeof(BITMAPINFOHEADER) +
    256 * sizeof(RGBQUAD);
  BITMAPINFO* pDIB =
    reinterpret_cast<BITMAPINFO*>(
      new unsigned char[dib_size]
      );

  // zero-out all fields and then
  // specify the header size
  memset(pDIB, 0, dib_size);
  pDIB->bmiHeader.biSize =
    sizeof(BITMAPINFOHEADER);

  // grab a handle to the screen's DC
  const HDC hScnDC = GetDC(NULL);

  // create a 1x1 DDB which we'll use to
  // determine the format of the device's
  // internal memory surface
  const HBITMAP hDDB =
    CreateCompatibleBitmap(hScnDC, 1, 1);

  // use the DDB and the GetDIBits()
  // function with a NULL lpvBits
  // parameter to query the format of
  // the device-managed surface
  bool got_ok = GetDIBits(
    hScnDC, hDDB, 0, 1, NULL, pDIB,
    DIB_RGB_COLORS
    );
  if (got_ok)
  {
    // get the optimal bitfield info
    // (for 15/16- or 32-bpp bitmaps)
    got_ok = GetDIBits(
      hScnDC, hDDB, 0, 1, NULL, pDIB,
      DIB_RGB_COLORS
      );
  }
  // delete the DDB
  DeleteObject(hDDB);
  
  if (got_ok)
  {
    // get the optimal color-depth
    opt_bpp = pDIB->bmiHeader.biBitCount;

    // set the proper dimensions; create
    // a top-down DIB section by setting
    // the biHeight data member negative
    pDIB->bmiHeader.biWidth = SBmp.cx;
    pDIB->bmiHeader.biHeight = -SBmp.cy;

    // create the optimal DIB section
    // bitmap based on the information
    // in pDIB (which the GetDIBits()
    // calls should have filled in)
    hDIBSection =
      CreateDIBSection(
        hScnDC, pDIB, DIB_RGB_COLORS,
        NULL, NULL, 0
        );
  }
  // release the screen's DC
  ReleaseDC(NULL, hScnDC);

  // free the BITMAPINFO
  delete [] reinterpret_cast
    <unsigned char*>(pDIB);

  //
  // copy (and convert) the pixels of
  // Bitmap to the optimal format DIB
  // section bitmap
  //
  if (hDIBSection != NULL)
  {
    HDC hMemDC = NULL;
    HBITMAP hOldBmp = NULL;
    bool blt_ok = false;
    try
    {
      // associate the DIB section bitmap
      // with a memory DC (for drawing)
      hMemDC = CreateCompatibleDC(NULL);
      hOldBmp = static_cast<HBITMAP>(
        SelectObject(hMemDC, hDIBSection)
        );

      // sync the color tables
      if (opt_bpp <= 8)
      {
        // get Bitmap's color table
        RGBQUAD rgbQ[256];
        UINT num_entries =
          GetDIBColorTable(
            hBmpDC, 0, 256, rgbQ
            );

        // if Bitmap has no color table,
        // let's use its Palette instead
        if (num_entries == 0)
        {
          // grab a handle to Bitmap's
          // logical palette
          const HPALETTE hPal =
            Bitmap.Palette;

          // get the number of Bitmap's
          // palette entries
          num_entries =
            GetPaletteEntries(
              hPal, 0, 0, NULL
              );
              
          // create a LOGPALETTE buffer
          const std::size_t pal_size =
            sizeof(LOGPALETTE) +
            (num_entries - 1) *
            sizeof(PALETTEENTRY);
          LOGPALETTE* pLogPal =
            reinterpret_cast
              <LOGPALETTE*>(
              new unsigned char[pal_size]
              );

          // copy the palette data
          const UINT num_got =
            GetPaletteEntries(
              hPal, 0, num_entries,
              pLogPal->palPalEntry
              );
          for (UINT i=0; i<num_got; ++i)
          {
            rgbQ[i].rgbRed = pLogPal->
              palPalEntry[i].peRed;
            rgbQ[i].rgbGreen = pLogPal->
              palPalEntry[i].peGreen;
            rgbQ[i].rgbBlue = pLogPal->
              palPalEntry[i].peBlue;
          }

          // free the LOGPALETTE buffer
          delete [] reinterpret_cast
            <unsigned char*>(pLogPal);
        }
        if (num_entries > 0)
        {
          // copy the colors in rgbQ to
          // hDIBSection's color table
          SetDIBColorTable(
            hMemDC, 0, num_entries, rgbQ
            );
        }
      }

      // copy and convert the pixels of
      // Bitmap to the DIB section bitmap
      blt_ok = BitBlt(
        hMemDC, 0, 0, SBmp.cx, SBmp.cy,
        Bitmap.Canvas->Handle, 0, 0,
        SRCCOPY
        );

      // assign the optimal DIB section
      // bitmap to Bitmap (the TBitmap
      // object will take ownership)
      if (blt_ok)
      {
        Bitmap.Handle = hDIBSection;
      }
    }
    __finally
    {
      // clean up
      SelectObject(hMemDC, hOldBmp);
      DeleteDC(hMemDC);
      if (!blt_ok)
      {
        DeleteObject(hDIBSection);
      }
    }
  }
  // return the optimal color depth
  return opt_bpp;
}

AnsiString GetBitmapFormat(
   Graphics::TBitmap& Bitmap
  )
{
  switch (Bitmap.PixelFormat)
  {
    case pfDevice: return "DDB";
    case pf1bit: return "1-bpp";
    case pf4bit: return "4-bpp";
    case pf8bit: return "8-bpp";
    case pf15bit: return "15-bpp";
    case pf16bit: return "16-bpp";
    case pf24bit: return "24-bpp";
    case pf32bit: return "32-bpp";
    default: return "Unknown";
  }
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Graphics::TBitmap& Bmp =
    *Image1->Picture->Bitmap;

  ShowMessage(
    "Current bitmap format = " +
    GetBitmapFormat(Bmp) + "."
    );
    
  MakeBitmapOptimal(Bmp);
  Image1->Refresh();

  ShowMessage(
    "Optimal bitmap format = " +
    GetBitmapFormat(Bmp) + "."
    );
}
//---------------------------------------------------------------------------

