//===========================================================================
#ifndef SGDropTargetH
#define SGDropTargetH
//===========================================================================
#include <ole2.h>
//===========================================================================

static const int
  WM_OLEDRAGOVER = WM_USER + 101;
static const int
  WM_OLEDRAGDROP = WM_USER + 102;
//---------------------------------------------------------------------------

class TSGDropTarget : public IDropTarget
{
private:
  unsigned long num_refs_;   // number of references
  TWinControl* TargetWnd_;   // target window
  TPoint PMouse_;            // current pos of mouse cursor
  bool format_ok_;           // data format acceptance flag
    
protected:
  // IUnknown member functions
  STDMETHOD(QueryInterface)(REFIID riid,
    void** ppvObj);
  STDMETHOD_(ULONG, AddRef)();
  STDMETHOD_(ULONG, Release)();

  // IDropTarget member functions
  STDMETHOD(DragEnter)(
    LPDATAOBJECT pDataObj,
    DWORD grfKeyState, POINTL pt,
    LPDWORD pdwEffect);
  STDMETHOD(DragOver)(DWORD grfKeyState,
    POINTL pt, LPDWORD pdwEffect);
  STDMETHOD(Drop)(LPDATAOBJECT pDataObj,
    DWORD grfKeyState, POINTL pt,
    LPDWORD pdwEffect);
  STDMETHOD(DragLeave)()
    { return E_NOTIMPL; };    

public:
  TSGDropTarget(
    TWinControl* ATargetWnd_);
  ~TSGDropTarget();
};
//===========================================================================
#endif

