
//===========================================================================
#include <vcl.h>
#pragma hdrstop

#include "BasicDropTarget.h"
#pragma package(smart_init)
//===========================================================================

// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//
static inline void
  ValidCtrCheck(TBasicDropTarget*)
{
  new TBasicDropTarget(NULL);
}
//---------------------------------------------------------------------------

namespace Basicdroptarget
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] =
      {__classid(TBasicDropTarget)};
    RegisterComponents(
      "Samples", classes, 0);
  }
}
//---------------------------------------------------------------------------
//===========================================================================


__fastcall TBasicDropTarget::
  TBasicDropTarget(TComponent* Owner) :
    TComponent(Owner),
    Interface_(new TIDropTarget(this))
{
  OleInitialize(NULL);
  OleCheck(
    CoLockObjectExternal(
      Interface_, true, true
      ));
}
//---------------------------------------------------------------------------

__fastcall TBasicDropTarget::
  ~TBasicDropTarget()
{
  CoLockObjectExternal(
    Interface_, false, true);
  Interface_->Release();
  OleUninitialize();
}
//---------------------------------------------------------------------------
//===========================================================================



HRESULT STDMETHODCALLTYPE TIDropTarget::
  DragEnter(IDataObject* pDataObj,
   DWORD Keys, POINTL PMouse,
   DWORD* pEffect)
{
  *pEffect = DROPEFFECT_NONE;
  if (pDataObj != NULL && Owner_ != NULL)
  {
    Owner_->DoDragEnter(pDataObj,
      PMouse.x, PMouse.y, 
      KeysToShiftState(Keys), *pEffect);
  }
  SaveEffect = *pEffect;
  return NOERROR;
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE TIDropTarget::
  DragOver(DWORD Keys, POINTL PMouse,
   DWORD* pEffect)
{
  *pEffect = SaveEffect;
  if (Owner_ != NULL)
  {
    Owner_->DoDragOver(
      PMouse.x, PMouse.y,
      KeysToShiftState(Keys), *pEffect);
  }
  SaveEffect = *pEffect;  
  return NOERROR;
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE TIDropTarget::
  DragLeave()
{
  if (Owner_ != NULL)
  {
    Owner_->DoDragLeave();
  }
  return NOERROR;
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE TIDropTarget::
  Drop(IDataObject* pDataObj,
   DWORD Keys, POINTL PMouse,
   DWORD* pEffect)
{
  *pEffect = SaveEffect;
  if (pDataObj != NULL && Owner_ != NULL)
  {
    return Owner_->DoDrop(
      pDataObj, PMouse.x, PMouse.y,
      KeysToShiftState(Keys), *pEffect);
  }
  return NOERROR;
}
//---------------------------------------------------------------------------
//===========================================================================



