
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit_DDExample1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "BasicDropTarget"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(
  TComponent* Owner) : TForm(Owner)
{
  // grab a pointer to IDropTarget
  IDropTarget* pInterface =
    BasicDropTarget1->Interface;

  // register the static-text control
  OleCheck(
    RegisterDragDrop(
      StaticText1->Handle, pInterface
      ));
  // register the list box
  OleCheck(
    RegisterDragDrop(
      ListBox1->Handle, pInterface
      ));
}
//---------------------------------------------------------------------------

__fastcall TForm1::~TForm1()
{
  // clean up
  RevokeDragDrop(ListBox1->Handle);
  RevokeDragDrop(StaticText1->Handle);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  BasicDropTarget1DragEnter(
    TBasicDropTarget *Sender,
    IDataObject *pDataObj, int X, int Y,
    TShiftState Shift, DWORD &Effect)
{
  // initialize the FORMATETC member
  format_.cfFormat = 0;
  format_.ptd = NULL;
  format_.dwAspect = DVASPECT_CONTENT;
  format_.lindex = -1;
  format_.tymed = TYMED_HGLOBAL;

  // determine which control
  // is being dragged over
  TWinControl* HitControl =
    FindVCLWindow(Point(X, Y));
  if (HitControl == StaticText1)
  {
    format_.cfFormat = CF_TEXT;
  }
  else if (HitControl == ListBox1)
  {
    format_.cfFormat = CF_HDROP;
  }

  // see if text or files are available
  if (format_.cfFormat == CF_TEXT ||
      format_.cfFormat == CF_HDROP)
  {
    HRESULT const hRes =
      pDataObj->QueryGetData(&format_);
    if (hRes == S_OK)
    {
      Effect = DROPEFFECT_COPY;
    }
    // otherwise, leave Effect at its
    // default value of DROPEFFECT_NONE
    // which was assigned in the
    // TIDropTarget::DragEnter() method
  }
}
//---------------------------------------------------------------------------

HRESULT __fastcall TForm1::
  BasicDropTarget1Drop(
    TBasicDropTarget *Sender,
    IDataObject *pDataObj, int X, int Y,
    TShiftState Shift, DWORD &Effect)
{
  // a handle to the data will be
  // specified in storage_medium
  STGMEDIUM storage_medium;

  // get the data
  HRESULT const hRes = pDataObj->
    GetData(&format_, &storage_medium);
  if (FAILED(hRes))
  {
    return hRes;
  }
  try
  {
    // decode the data
    if (format_.cfFormat == CF_TEXT)
    {
      GetDroppedText(storage_medium);
    }
    else // format.cfFormat == CF_HDROP
    {
      GetDroppedFiles(storage_medium);
    }
  }
  __finally
  {
    // free the memory associated
    // with the dropped object
    ReleaseStgMedium(&storage_medium);
  }
  return NOERROR;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  GetDroppedText(STGMEDIUM const& storage_medium)
{
  char const* pText = reinterpret_cast<char*>(
    GlobalLock(storage_medium.hGlobal)
    );
  if (pText == NULL) return;
  try
  {
    StaticText1->Caption = pText;
  }
  __finally
  {
    GlobalUnlock(storage_medium.hGlobal);
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  GetDroppedFiles(STGMEDIUM const& storage_medium)
{
  HDROP const hDrop = reinterpret_cast<HDROP>(
    GlobalLock(storage_medium.hGlobal)
    );
  if (hDrop == NULL) return;      
  try
  {
    // clear the list box
    ListBox1->Clear();

    // query the number of files dropped
    UINT const num_files =
      DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);

    // grab the files' names
    char filename[MAX_PATH];
    for (UINT idx = 0; idx < num_files; ++idx)
    {
      DragQueryFile(hDrop, idx, filename, MAX_PATH);
      ListBox1->Items->Add(filename);
    }
  }
  __finally
  {
    GlobalUnlock(storage_medium.hGlobal);
  }
}
//---------------------------------------------------------------------------

