
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit_DDExample2.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "BasicDropTarget"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

void ShiftStateToEffect(
  TShiftState Shift, DWORD& Effect,
  bool LinkOK = false)
{
  if (LinkOK && Shift.Contains(ssAlt))
  {
    // ALT+CTRL or ALT+SHIFT
    // keys => default effect
    if (Shift.Contains(ssCtrl) ||
        Shift.Contains(ssShift))
    {
      return;
    }
    // ALT key alone => link
    else
    {
      Effect = DROPEFFECT_LINK;
    }
  }
  else if (Shift.Contains(ssShift))
  {
    // SHIFT+CTRL keys => link
    if (LinkOK && Shift.Contains(ssCtrl))
    {
      Effect = DROPEFFECT_LINK;
    }
    // SHIFT key on a copy => move
    else if (Effect & DROPEFFECT_COPY)
    {
      Effect = DROPEFFECT_MOVE;
    }
  }
  // CTRL key alone always copies
  else if (Shift.Contains(ssCtrl))
  {
    Effect = DROPEFFECT_COPY;
  }
}
//---------------------------------------------------------------------------



__fastcall TForm1::TForm1(
  TComponent* Owner) : TForm(Owner)
{
  // grab a pointer to IDropTarget
  IDropTarget* pInterface =
    BasicDropTarget1->Interface;

  // register the form
  OleCheck(
    RegisterDragDrop(Handle, pInterface)
    );
}
//---------------------------------------------------------------------------

__fastcall TForm1::~TForm1()
{
  // clean up
  RevokeDragDrop(Handle);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  BasicDropTarget1DragEnter(
    TBasicDropTarget *Sender,
    IDataObject *pDataObj, int X, int Y,
    TShiftState Shift, DWORD &Effect)
{
  // grab a pointer to the
  // IEnumFormatEtc interface
  IEnumFORMATETC* pEnumFormatEtc;
  HRESULT const hRes =
    pDataObj->EnumFormatEtc(
      DATADIR_GET, &pEnumFormatEtc
      );
  if (FAILED(hRes)) return;

  // get the list of provided formats
  while (pEnumFormatEtc->
    Next(1, &format_, NULL) != S_FALSE)
  {
    // look for DIB or EMF formats
    if (format_.cfFormat ==
        CF_ENHMETAFILE)
    {
      Effect = DROPEFFECT_COPY;
      break;
    }
  }

  // if an EMF isn't available,
  // let's look for a DIB
  if (Effect != DROPEFFECT_COPY)
  {
    pEnumFormatEtc->Reset(); // rewind
    while (pEnumFormatEtc->
      Next(1, &format_, NULL) != S_FALSE)
    {
      // look for DIB or EMF formats
      if (format_.cfFormat == CF_DIB)
      {
        Effect = DROPEFFECT_COPY;
        break;
      }
    }
  }

  // clean up
  pEnumFormatEtc->Release();

  // if one of our formats are available,
  // change Effect according to which
  // modifier keys are pressed
  if (Effect != DROPEFFECT_NONE)
  {
    ShiftStateToEffect(Shift, Effect);
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  BasicDropTarget1DragOver(
    TBasicDropTarget *Sender,
    int X, int Y, TShiftState Shift,
    DWORD &Effect)
{
  if (Effect != DROPEFFECT_NONE)
  {
    Effect = DROPEFFECT_COPY;
    ShiftStateToEffect(Shift, Effect);
  }
}
//---------------------------------------------------------------------------

HRESULT __fastcall TForm1::
  BasicDropTarget1Drop(
    TBasicDropTarget *Sender,
    IDataObject *pDataObj, int X, int Y,
    TShiftState Shift, DWORD &Effect)
{
  // a handle to the data will be
  // specified in storage_medium
  STGMEDIUM storage_medium;

  // get the image data
  HRESULT const hRes = pDataObj->
    GetData(&format_, &storage_medium);
  if (FAILED(hRes)) return hRes;
  try
  {
    if (format_.cfFormat == CF_DIB)
    {
      // decode the DIB data
      GetDroppedDIB(storage_medium);
    }
    else // it's an EMF
    {
      // decode the EMF data
      GetDroppedEMF(storage_medium);
    }
  }
  __finally
  {
    // free the memory associated
    // with the dropped object
    ReleaseStgMedium(&storage_medium);
  }
  return NOERROR;  
}
//---------------------------------------------------------------------------

#include <memory>
void __fastcall TForm1::
  GetDroppedDIB(STGMEDIUM const& storage_medium)
{
  BITMAPINFO* pDIB = reinterpret_cast<BITMAPINFO*>(
    GlobalLock(storage_medium.hGlobal)
    );
  if (pDIB == NULL) return;
  try
  {
    // determine the number of color-table entries
    UINT num_colors = pDIB->bmiHeader.biClrUsed;
    if (num_colors == 0 &&
        pDIB->bmiHeader.biBitCount <= 8)
    {
      num_colors = 1 << pDIB->bmiHeader.biBitCount;
    }

    // initialize the file header
    BITMAPFILEHEADER bmfh;
    bmfh.bfType = 0x4D42;
    bmfh.bfSize =
      sizeof(BITMAPFILEHEADER) +
      sizeof(BITMAPINFOHEADER) +
      num_colors * sizeof(RGBQUAD) +
      pDIB->bmiHeader.biSizeImage;
    bmfh.bfOffBits =
      bmfh.bfSize - pDIB->bmiHeader.biSizeImage;

    // create a stream and write the DIB to it
    std::auto_ptr<TMemoryStream>
      ms(new TMemoryStream());
    ms->Write(&bmfh, sizeof(BITMAPFILEHEADER));
    ms->Write(pDIB, bmfh.bfSize -
      sizeof(BITMAPFILEHEADER));
    ms->Seek(0, soFromBeginning);

    // load the DIB from the stream
    Image1->Picture->Bitmap->
      LoadFromStream(ms.get());
  }
  __finally
  {
    GlobalUnlock(storage_medium.hGlobal);
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  GetDroppedEMF(STGMEDIUM const& storage_medium)
{
  HENHMETAFILE const hEMF = CopyEnhMetaFile(
    storage_medium.hEnhMetaFile, NULL
    );
  try
  {
    Image1->Picture->Metafile->Handle =
      reinterpret_cast<int>(hEMF);
  }
  catch (...)
  {
    DeleteEnhMetaFile(hEMF);
    throw;
  }
}
//---------------------------------------------------------------------------

/*
FORMATETC fmtetc;
  fmtetc.cfFormat = CF_ENHMETAFILE;
  fmtetc.ptd = NULL;
  fmtetc.dwAspect = DVASPECT_CONTENT;
  fmtetc.lindex = -1;
  fmtetc.tymed = TYMED_ENHMF;

  STGMEDIUM stg_med;
  HRESULT const hRes = pDataObj->
    GetData(&fmtetc, &stg_med);
  if (SUCCEEDED(hRes))
  {
    // load the metafile
    Image1->Picture->Metafile;
    Image1->Picture->Metafile->Handle =
      (int)stg_med.hEnhMetaFile;

    Caption = (int)stg_med.pUnkForRelease;

    // free the associated memory
    // ReleaseStgMedium(&smed);
  }
*/
//---------------------------------------------------------------------------


