
//===========================================================================
#include <basepch.h>
#pragma hdrstop

#include "BasicDropTarget.h"
#pragma package(smart_init)
//===========================================================================

// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//
static inline void
  ValidCtrCheck(TBasicDropTarget*)
{
  new TBasicDropTarget(NULL);
}
//---------------------------------------------------------------------------

namespace Basicdroptarget
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] =
      {__classid(TBasicDropTarget)};
    RegisterComponents(
      "Samples", classes, 0);
  }
}
//---------------------------------------------------------------------------
//===========================================================================



__fastcall TBasicDropTarget::
  TBasicDropTarget(TComponent* Owner) :
    TComponent(Owner), IDropTarget(),
    ref_count_(1), SaveEffect(0)
{
  OleInitialize(NULL);
  OleCheck(
    CoLockObjectExternal(
      static_cast<IDropTarget*>(this),
      true, true)
      );
}
//---------------------------------------------------------------------------

__fastcall TBasicDropTarget::
  ~TBasicDropTarget()
{
  CoLockObjectExternal(
    static_cast<IDropTarget*>(this),
    false, true);
  OleUninitialize();
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE
  TBasicDropTarget::DragEnter(
    IDataObject* pDataObj, DWORD Keys,
    POINTL PMouse, DWORD* pEffect)
{
  *pEffect = DROPEFFECT_NONE;
  if (pDataObj != NULL)
  {
    DoDragEnter(pDataObj,
      PMouse.x, PMouse.y, 
      KeysToShiftState(Keys), *pEffect);
  }
  SaveEffect = *pEffect;
  return NOERROR;
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE
  TBasicDropTarget::DragOver(DWORD Keys,
    POINTL PMouse, DWORD* pEffect)
{
  *pEffect = SaveEffect;
  DoDragOver(PMouse.x, PMouse.y,
    KeysToShiftState(Keys), *pEffect);
  SaveEffect = *pEffect;  
  return NOERROR;
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE
  TBasicDropTarget::DragLeave()
{
  DoDragLeave();
  return NOERROR;
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE TBasicDropTarget::
  Drop(IDataObject* pDataObj,
   DWORD Keys, POINTL PMouse,
   DWORD* pEffect)
{
  *pEffect = SaveEffect;
  if (pDataObj != NULL)
  {
    return DoDrop(
      pDataObj, PMouse.x, PMouse.y,
      KeysToShiftState(Keys), *pEffect);
  }
  return NOERROR;
}
//---------------------------------------------------------------------------
//===========================================================================



