
//===========================================================================
#ifndef BasicDropTargetH
#define BasicDropTargetH
//===========================================================================
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <ComObj.hpp>
#include <Forms.hpp>
#include <ole2.h>
//---------------------------------------------------------------------------

class DELPHICLASS TBasicDropTarget;
typedef void __fastcall
  (__closure *TOLEDragEnterEvent)(
    TBasicDropTarget* Sender,
    IDataObject* pDataObj,
    int X, int Y,    
    TShiftState Shift,
    DWORD& Effect
    );
typedef void __fastcall
  (__closure *TOLEDragOverEvent)(
    TBasicDropTarget* Sender,
    int X, int Y,
    TShiftState Shift,
    DWORD& Effect
    );
typedef void __fastcall
  (__closure *TOLEDragLeaveEvent)(
    TBasicDropTarget* Sender
    );
typedef HRESULT __fastcall
  (__closure *TOLEDropEvent)(
    TBasicDropTarget* Sender,
    IDataObject* pDataObj,
    int X, int Y,
    TShiftState Shift,
    DWORD& Effect
    );

class PACKAGE TBasicDropTarget :
  public TComponent, public IDropTarget
{
__published:
  __property TOLEDragEnterEvent OnDragEnter =
    {read = OnDragEnter_, write = OnDragEnter_};
  __property TOLEDragOverEvent OnDragOver =
    {read = OnDragOver_, write = OnDragOver_};
  __property TOLEDragLeaveEvent OnDragLeave =
    {read = OnDragLeave_, write = OnDragLeave_};
  __property TOLEDropEvent OnDrop =
    {read = OnDrop_, write = OnDrop_};

public:
  __fastcall TBasicDropTarget(TComponent* Owner);
  __fastcall ~TBasicDropTarget();
      
  __property LONG RefCount =
    {read = ref_count_, write = ref_count_};

public: // inherited from IUnknown
  virtual ULONG STDMETHODCALLTYPE AddRef()
    {
      InterlockedIncrement(&ref_count_);
      return ref_count_;
    }
  virtual ULONG STDMETHODCALLTYPE Release()
    {
      if (InterlockedDecrement(&ref_count_) == 0)
      {
        delete this;
      }
      return ref_count_;
    }
#pragma warn -8022
  virtual HRESULT STDMETHODCALLTYPE
    QueryInterface(REFIID riid, void** ppvObj)
    {
      if (IsEqualIID(riid, IID_IUnknown) ||
          IsEqualIID(riid, IID_IDropTarget))
      {
        *ppvObj = static_cast<IDropTarget*>(this);
        AddRef();
        return NOERROR;
      }
      *ppvObj = NULL;
      return E_NOINTERFACE;
    }
#pragma warn .8022    

protected: // inherited from IDropTarget
  STDMETHODIMP DragEnter(
    IDataObject* pDataObj, DWORD KeyState,
    POINTL PMouse, DWORD* pEffect);
  STDMETHODIMP DragOver(
    DWORD KeyState, POINTL PMouse, DWORD* pEffect);
  STDMETHODIMP DragLeave();
  STDMETHODIMP Drop(
    IDataObject* pDataObj, DWORD KeyState,
    POINTL PMouse, DWORD* pEffect);

protected: // introduced    
  virtual void DoDragEnter(IDataObject* pDataObj,
    int X, int Y, TShiftState Shift, DWORD& Effect)
    {
      if (OnDragEnter_ != NULL)
      {
        OnDragEnter_(this,
          pDataObj, X, Y, Shift, Effect);
      }
    }
  virtual void DoDragOver(int X, int Y,
    TShiftState Shift, DWORD& Effect)
    {
      if (OnDragOver_ != NULL)
      {
        OnDragOver_(this, X, Y, Shift, Effect);
      }
    }
  virtual void DoDragLeave()
    {
      if (OnDragLeave_ != NULL)
      {
        OnDragLeave_(this);
      }
    }
  virtual HRESULT DoDrop(IDataObject* pDataObj,
    int X, int Y, TShiftState Shift, DWORD& Effect)
    {
      if (OnDrop_ != NULL)
      {
        return OnDrop_(this,
          pDataObj, X, Y, Shift, Effect);
      }
      return NOERROR;
    }

private:
  TOLEDragEnterEvent OnDragEnter_;
  TOLEDragOverEvent OnDragOver_;
  TOLEDragLeaveEvent OnDragLeave_;
  TOLEDropEvent OnDrop_;
    
private:
  LONG ref_count_;
  DWORD SaveEffect;
};
//---------------------------------------------------------------------------

//===========================================================================
#endif
//===========================================================================
 