// REMOTEBIOLIFEIMPL.H : Declaration of the RemoteBiolife

#ifndef RemoteBiolifeImplH
#define RemoteBiolifeImplH

#define ATL_FREE_THREADED
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <MidConst.hpp>

#include "BCB6DataSnapServer_TLB.H"
#include <DB.hpp>
#include <DBTables.hpp>
#include <Provider.hpp>
#include <atl/atlvcl.h>



// Forward ref. of IAppServer implementor


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
class TRemoteBiolife : public TCRemoteDataModule
{
__published:  // IDE-managed Components
        TSession *Session1;
        TTable *tblBiolife;
        TDataSetProvider *dspBiolife;
private:      // User declarations
public:       // User declarations
  __fastcall TRemoteBiolife(TComponent* Owner);

__published:
};


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
extern PACKAGE TRemoteBiolife *RemoteBiolife;


/////////////////////////////////////////////////////////////////////////////
// TRemoteBiolifeImpl     Implements IRemoteBiolife, default interface of RemoteBiolife
// ThreadingModel : Apartment
// Dual Interface : TRUE
// Event Support  : FALSE
// Default ProgID : BCB6DataSnapServer.RemoteBiolife
// Description    : Remote Data Module for Biolife Table
/////////////////////////////////////////////////////////////////////////////
class ATL_NO_VTABLE TRemoteBiolifeImpl: REMOTEDATAMODULE_IMPL(TRemoteBiolifeImpl, RemoteBiolife, TRemoteBiolife, IRemoteBiolife)
{
public:

BEGIN_COM_MAP(TRemoteBiolifeImpl)
  RDMOBJECT_COM_INTERFACE_ENTRIES(IRemoteBiolife)
END_COM_MAP()

  // Data used when registering Object 
  //
  DECLARE_THREADING_MODEL(otApartment);
  DECLARE_PROGID(_T("BCB6DataSnapServer.RemoteBiolife"));
  DECLARE_DESCRIPTION(_T("Remote Data Module for Biolife Table"));

  // Function invoked to (un)register object
  //
  static HRESULT WINAPI UpdateRegistry(BOOL bRegister)
  {
    TRemoteDataModuleRegistrar regObj(GetObjectCLSID(), GetProgID(), GetDescription());
    // Disable these flags in order to disable use by socket or web connections.
    // Also set other flags to configure the behavior of your application server.
    // For more information, see atlmod.h and atlvcl.cpp.
    regObj.Singleton = false;
    regObj.EnableWeb = true;
    regObj.EnableSocket = true;
    return regObj.UpdateRegistry(bRegister);
  }


// IRemoteBiolife
protected:
};

#endif  // RemoteBiolifeImplH

