//---------------------------------------------------------------------------

#include <windows.h>
#pragma hdrstop
LRESULT FAR PASCAL _export
  WndProc(HWND, UINT, WPARAM, LPARAM);

int PASCAL WinMain(
  HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpszCmd, int nCmdShow)
{
  static char AppName[] = "HelloWorld";
  HWND        hwnd;
  MSG         msg;
  WNDCLASS    wndclass;
  if (!hPrevInstance)
  {
    wndclass.style = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc = (WNDPROC)WndProc;
    wndclass.cbClsExtra = 0;
    wndclass.cbWndExtra = 0;
    wndclass.hInstance = hInstance;
    wndclass.hIcon =
      LoadIcon(NULL, IDI_APPLICATION);
    wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground =
      (HBRUSH)GetStockObject(WHITE_BRUSH);
    wndclass.lpszMenuName = 0;
    wndclass.lpszClassName = AppName;

    RegisterClass(&wndclass);
  }

  hwnd = CreateWindow(AppName,
    "Hello World",
    WS_OVERLAPPEDWINDOW,
    CW_USEDEFAULT,
    CW_USEDEFAULT,
    CW_USEDEFAULT,
    CW_USEDEFAULT,
    NULL,
    NULL,
    hInstance,
    NULL);

  ShowWindow(hwnd, SW_NORMAL);

  while (GetMessage(&msg, NULL, 0, 0))
  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return msg.wParam;
}

LRESULT FAR PASCAL _export
WndProc(HWND hwnd,
  UINT message, WPARAM wParam, LPARAM lParam)
{
  switch(message)
  {
    case WM_PAINT :
    {
      char text[] = "Hello World!!";
      PAINTSTRUCT ps;
      BeginPaint(hwnd, &ps);
      TextOut(ps.hdc, 20, 20, text, 13);
      EndPaint(hwnd, &ps);
      break;
    }
    case WM_DESTROY : {
      PostQuitMessage(0);
      return 0;
    }
    default:
      return DefWindowProc(
        hwnd, message, wParam, lParam);
  }
  return 0;
}

