/****************************************************************************\

    StringGridDemo.cpp -- Created by Damon Chandler <dmc27@cornell.edu>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************

\****************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "StringGridDemo.h"
#include <cassert>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

/*** BEGIN Check Box Helper Functions ***/

void __fastcall InvalidateCell(TStringGrid& AGrid, int ACol, int ARow)
{
   AGrid.Objects[ACol][ARow] = AGrid.Objects[ACol][ARow]; 
}

bool __fastcall GetCheckState(TStringGrid& AGrid, int ACol, int ARow)
{
   return HIWORD(reinterpret_cast<long>(AGrid.Objects[ACol][ARow]));
}

void __fastcall SetCheckState(TStringGrid& AGrid, int ACol, int ARow,
   bool AChecked)
{
   long data = reinterpret_cast<long>(AGrid.Objects[ACol][ARow]);
   AGrid.Objects[ACol][ARow] = reinterpret_cast<TObject*>(
      MAKELONG(LOWORD(data), AChecked)
      );
}

bool __fastcall GetCheckBox(TStringGrid& AGrid, int ACol, int ARow)
{
   return LOWORD(reinterpret_cast<long>(AGrid.Objects[ACol][ARow]));
}

void __fastcall SetCheckBox(TStringGrid& AGrid, int ACol, int ARow,
   bool AShow, bool AChecked)
{
   AGrid.Objects[ACol][ARow] = reinterpret_cast<TObject*>(
      MAKELONG(AShow, false)
      );
   SetCheckState(AGrid, ACol, ARow, AChecked);
}

bool __fastcall PtInCheckBox(TStringGrid& AGrid, int AX, int AY,
   int &ACol, int &ARow)
{
   AGrid.MouseToCell(AX, AY, ACol, ARow);
   RECT RCell = static_cast<RECT>(AGrid.CellRect(ACol, ARow));

   OffsetRect(&RCell, 2, 0.5 * (RCell.bottom - RCell.top));
   RCell.right = RCell.left + GetSystemMetrics(SM_CXMENUCHECK);
   RCell.bottom = RCell.top + GetSystemMetrics(SM_CYMENUCHECK);
   RCell.top -= 0.5 * (RCell.bottom - RCell.top) + 2;

   return PtInRect(&RCell, Point(AX, AY));
}
/*** END Check Box Helper Functions ***/

//---------------------------------------------------------------------------


__fastcall TForm1::TForm1(TComponent* Owner)
   : TForm(Owner)
{
   StringGrid1->ColWidths[0] = 45;
   const int col_max = StringGrid1->ColCount;
   const int row_max = StringGrid1->RowCount;

   for (int col = StringGrid1->FixedCols; col < col_max; ++col)
   {
      for (int row = StringGrid1->FixedRows; row < row_max; ++row)
      {
         StringGrid1->Cells[col][row] =
            "Cell: (" + IntToStr(col) + ", " + IntToStr(row) + ")";
         SetCheckBox(*StringGrid1, col, row, true, true);
      }
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::StringGrid1DrawCell(TObject *Sender,
   int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
   TStringGrid* StringGrid = static_cast<TStringGrid*>(Sender);
   assert(StringGrid != NULL);

   TCanvas* SGCanvas = StringGrid->Canvas;
   SGCanvas->Font = StringGrid->Font;
   
   RECT RText = static_cast<RECT>(Rect);
   const AnsiString text(StringGrid->Cells[ACol][ARow]);

   const bool has_checkBox =
      GetCheckBox(*StringGrid, ACol, ARow);
      
   const bool fixed = State.Contains(gdFixed);
   const bool focused = State.Contains(gdFocused);
   bool selected = State.Contains(gdSelected);
   if (!StringGrid1->Options.Contains(goDrawFocusSelected))
   {
      selected = selected && !focused;
   }

   // if the cell is fixed (headers)
   if (fixed)
   {
      SGCanvas->Brush->Color = StringGrid1->FixedColor;
      SGCanvas->Font->Color = clBtnText;
      SGCanvas->FillRect(Rect);
      Frame3D(SGCanvas, Rect, clBtnHighlight, clBtnShadow, 1);
   }
   // if the cell is selected
   else if (selected)
   {
      unsigned char step = 30;
      unsigned char r = 0x80, g = 0x80, b = 0xC0;
      TColor clr_highlight = static_cast<TColor>(
         PALETTERGB(r + step, g + step, b + step)
         );
      TColor clr_shadow = static_cast<TColor>(
         PALETTERGB(r - step, g - step, b - step)
         );

      SGCanvas->Brush->Color = static_cast<TColor>(
         PALETTERGB(r, g, b)
         );
      SGCanvas->Font->Color = clWhite;
      SGCanvas->Font->Style = SGCanvas->Font->Style << fsItalic;

      SGCanvas->FillRect(Rect);
      Frame3D(SGCanvas, Rect, clr_shadow, clr_highlight, 3);
   }
   // if the cell is normal
   else
   {
      if (ARow % 2 == 0) SGCanvas->Brush->Color = clInfoBk;
      else SGCanvas->Brush->Color = StringGrid1->Color;

      SGCanvas->Font->Color = StringGrid1->Font->Color;
      SGCanvas->FillRect(Rect);
   }
   // if the cell is focused
   if (focused) DrawFocusRect(SGCanvas->Handle, &RText);

   // if this cell contains a checkbox
   if (has_checkBox)
   {
      // set the flags for rendering checked/unchecked
      unsigned int state = DFCS_BUTTONCHECK;
      if (GetCheckState(*StringGrid, ACol, ARow))
      {
          state = state | DFCS_CHECKED;
      }

      // size the checkbox
      RECT RCell = static_cast<RECT>(Rect);
      OffsetRect(&RCell, 2, 0.5 * (RCell.bottom - RCell.top));
      RCell.right = RCell.left + GetSystemMetrics(SM_CXMENUCHECK);
      RCell.bottom = RCell.top + GetSystemMetrics(SM_CYMENUCHECK);
      RCell.top -= 0.5 * (RCell.bottom - RCell.top) + 2;

      // draw the checkbox
      DrawFrameControl(StringGrid1->Canvas->Handle, &RCell,
                       DFC_BUTTON, state);

      // move the text over
      RText.left = RCell.right;
   }

   // draw the text
   RText.left += 2; RText.top += 2;
   DrawText(SGCanvas->Handle, text.c_str(), text.Length(),
            &RText, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::StringGrid1MouseDown(TObject *Sender,
   TMouseButton Button, TShiftState Shift, int X, int Y)
{
   TStringGrid* StringGrid = static_cast<TStringGrid*>(Sender);
   assert(StringGrid != NULL);

   int Col, Row;
   if (PtInCheckBox(*StringGrid, X, Y, Col, Row))
   {
      if (GetCheckBox(*StringGrid, Col, Row))
      {
         bool is_checked = GetCheckState(*StringGrid, Col, Row);
         SetCheckState(*StringGrid, Col, Row, !is_checked);
      }
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::StringGrid1KeyPress(TObject *Sender, char &Key)
{
   TStringGrid* StringGrid = static_cast<TStringGrid*>(Sender);
   assert(StringGrid != NULL);

   if (Key == VK_SPACE)
   {
      const int col = StringGrid->Col;
      const int row = StringGrid->Row;

      if (GetCheckBox(*StringGrid, col, row))
      {
         SetCheckState(*StringGrid, col, row,
            !GetCheckState(*StringGrid, col, row));
      }
   }
}
//---------------------------------------------------------------------------


