
//===========================================================================
#include <vcl.h>
#pragma hdrstop

#include "BitmapButton.h"
//===========================================================================
#pragma package(smart_init)
//===========================================================================

#if (__BORLANDC__ < 0x0530)
static inline TBitmapButton* ValidCtrCheck()
{
  return new TBitmapButton(NULL);
}
//---------------------------------------------------------------------------
#else
static inline void ValidCtrCheck(TBitmapButton*)
{
  new TBitmapButton(NULL);
}
//---------------------------------------------------------------------------
#endif

namespace Bitmapbutton
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] = {__classid(TBitmapButton)};
    RegisterComponents("Samples", classes, 0);
  }
}
//---------------------------------------------------------------------------

//===========================================================================

__fastcall TBitmapButton::
  TBitmapButton(TComponent* Owner)
    : TColorButton(Owner),
    NumFaces_(2), NoFocusRect_(false)
{
  Faces_ = new Graphics::TBitmap();
}
//---------------------------------------------------------------------------

__fastcall TBitmapButton::~TBitmapButton()
{
  delete Faces_;
}
//---------------------------------------------------------------------------

HPALETTE __fastcall TBitmapButton::
  GetPalette()
{
  if (!Faces_->Empty)
  {
    return Faces_->Palette;
  }
  return TColorButton::GetPalette();
}
//---------------------------------------------------------------------------

void __fastcall TBitmapButton::
  SetFaces(Graphics::TBitmap* Value)
{
  if (Faces_ != Value)
  {
    Faces_->Assign(Value);
    InvalidateRect(Handle, NULL, TRUE);
  }
}
//---------------------------------------------------------------------------

void __fastcall TBitmapButton::
  SetNumFaces(int Value)
{
  if (NumFaces_ != Value)
  {
    NumFaces_ = Value;
    InvalidateRect(Handle, NULL, TRUE);
  }
}
//---------------------------------------------------------------------------

void __fastcall TBitmapButton::
  SetNoFocusRect(bool Value)
{
  if (NoFocusRect_ != Value)
  {
    NoFocusRect_ = Value;
    InvalidateRect(Handle, NULL, FALSE);
  }
}
//---------------------------------------------------------------------------

void __fastcall TBitmapButton::
  DoDrawButtonFace(
    const TOwnerDrawState& state
  )
{
  // if no custom images have been set...
  if (Faces_->Empty)
  {
    // draw a normal push button
    TColorButton::
      DoDrawButtonFace(state);
  }
  // otherwise...
  else
  {
    TRect RSource = Rect(0, 0, 0, 0);

    // if the button is disabled
    if (!Enabled ||
        state.Contains(odDisabled))
    {
      switch (NumFaces_)
      {
        case 1:
        {
          RSource = Rect(
            0, 0, Faces_->Width,
            Faces_->Height
            );
          break;
        }
        case 2:
        {
          RSource = Rect(
            0, 0, Faces_->Width / 2,
            Faces_->Height
            );
          break;
        }
        case 3:
        {
          RSource = Rect(
            2 * Faces_->Width / 3, 0,
            Faces_->Width, Faces_->Height
            );
          break;
        }
      }
    }
    // otherwise, if the button is pushed
    else if (state.Contains(odSelected))
    {
      switch (NumFaces_)
      {
        case 1:
        {
          RSource = Rect(
            0, 0, Faces_->Width,
            Faces_->Height
            );
          break;
        }
        case 2:
        {
          RSource = Rect(
            Faces_->Width / 2, 0,
            Faces_->Width, Faces_->Height
            );
          break;
        }
        case 3:
        {
          RSource = Rect(
            Faces_->Width / 3, 0,
            2 * Faces_->Width / 3,
            Faces_->Height
            );
          break;
        }
      }
    }
    // otherwise (if normal)
    else
    {
      RSource = Rect(
        0, 0, Faces_->Width / NumFaces_,
        Faces_->Height
        );
    }

    // preserve colors
    SetStretchBltMode(
      Canvas->Handle, COLORONCOLOR
      );
    // render the face
    Canvas->CopyRect(
      ClientRect,
      Faces_->Canvas,
      RSource
      );
  }
}
//---------------------------------------------------------------------------

void __fastcall TBitmapButton::
  DoDrawButtonText(
    const TOwnerDrawState& state
  )
{
  // draw the caption...
  TOwnerDrawState new_state(state);
  TColorButton::DoDrawButtonText(
    NoFocusRect_ ?
    new_state >> odFocused : new_state
    );
}
//---------------------------------------------------------------------------

//===========================================================================

