
//===========================================================================
#ifndef BITMAPBUTTON_H
#define BITMAPBUTTON_H
//===========================================================================

#include "ColorButton.h"
//---------------------------------------------------------------------------

#if (__BORLANDC__ < 0x0530)
   #define DYNAMIC
   #define PACKAGE
#endif

class PACKAGE TBitmapButton : public TColorButton
{
public:
  __fastcall TBitmapButton(TComponent* Owner);
  __fastcall ~TBitmapButton();  

__published:
  __property Graphics::TBitmap* Faces =
    {read = Faces_, write = SetFaces};
  __property int NumFaces =
    {read = NumFaces_, write = SetNumFaces};
  __property bool NoFocusRect =
    {read = NoFocusRect_, write = SetNoFocusRect};

protected:
  DYNAMIC HPALETTE __fastcall GetPalette();
  virtual void __fastcall DoDrawButtonFace(
    const TOwnerDrawState& state);
  virtual void __fastcall DoDrawButtonText(
    const TOwnerDrawState& state);

private:
  Graphics::TBitmap* Faces_;
  int NumFaces_;
  bool NoFocusRect_;

  void __fastcall SetFaces(
    Graphics::TBitmap* Value);
  void __fastcall SetNumFaces(int Value);
  void __fastcall SetNoFocusRect(bool Value);
};

//===========================================================================
#endif // BITMAPBUTTON_H
//===========================================================================

