
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "ButtonDemo.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "BitmapButton"
#pragma link "ColorButton"
#pragma resource "*.dfm"
TForm1 *Form1;

enum {styleWin, styleMac, styleKDE};
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TitleImageMouseDown(TObject *Sender,
  TMouseButton Button, TShiftState Shift, int X, int Y)
{
  ReleaseCapture();
  SNDMSG(Handle, WM_NCLBUTTONDOWN, HTCAPTION, 0);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CloseButtonClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MinimizeButtonClick(TObject *Sender)
{
  if (Tag == styleMac)
  {
     static const int old_client_height = ClientHeight;
     if (ClientHeight != TitleBar->Height)
     {
       ClientHeight = TitleBar->Height;
     }
     else
     {
       ClientHeight = old_client_height;
     }
  }
  else
  {
    Application->Minimize();
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::WindowsButtonClick(TObject *Sender)
{
  BorderStyle = bsSingle;
  TitleBar->Hide();
  Color = clBtnFace;
  Panel1->BevelOuter = bvNone;
  Shape1->Hide();
  Font->Name = "Tahoma";  

  WindowsButton->Faces = NULL;
  MacButton->Faces = NULL;
  KDEButton->Faces = NULL;

  Memo1->Text = "Now in Windows style.";
  Tag = styleWin;  
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MacButtonClick(TObject *Sender)
{
  TitleImage->Picture->LoadFromFile("mac_title.bmp");
  BorderStyle = bsNone;
  TitleBar->Show();
  Color = static_cast<TColor>(RGB(220, 220, 220));
  Panel1->BevelOuter = bvRaised;
  
  Shape1->Pen->Color = clBlack;
  Shape1->Pen->Width = 1;
  Shape1->Show();

  Font->Name = "Fixedsys";
  TitleLabel->Left = 105;  
  TitleLabel->Font->Color = clBlack;
  TitleLabel->Font->Name = "Fixedsys";
  TitleLabel->Transparent = false;

  MacButton->Faces->LoadFromFile("mac_button.bmp");
  WindowsButton->Faces = MacButton->Faces;
  KDEButton->Faces = MacButton->Faces;
  CloseButton->Faces->LoadFromFile("mac_close.bmp");
  MinimizeButton->Faces->LoadFromFile("mac_minimize.bmp");

  Memo1->Text = "Now in Mac style.";
  Tag = styleMac;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::KDEButtonClick(TObject *Sender)
{
  TitleImage->Picture->LoadFromFile("kde_title.bmp");
  BorderStyle = bsNone;
  TitleBar->Show();
  Color = static_cast<TColor>(RGB(240, 240, 240));
  Panel1->BevelOuter = bvRaised;
  
  Shape1->Pen->Color = static_cast<TColor>(0x009A9A9A);
  Shape1->Pen->Width = 2;
  Shape1->Show();

  Font->Name = "Arial";
  TitleLabel->Left = 25;
  TitleLabel->Font->Color = clWhite;
  TitleLabel->Font->Name = "Arial";
  TitleLabel->Transparent = true;  

  KDEButton->Faces->LoadFromFile("kde_button.bmp");
  MacButton->Faces = KDEButton->Faces;
  WindowsButton->Faces = KDEButton->Faces;
  CloseButton->Faces->LoadFromFile("kde_close.bmp");
  MinimizeButton->Faces->LoadFromFile("kde_minimize.bmp");

  Memo1->Text = "Now in KDE style.";
  Tag = styleKDE;
}
//---------------------------------------------------------------------------

