//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "AADOQueryU.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
__fastcall TAADOQuery::TAADOQuery(Classes::TComponent* AOwner, int ConnectionId)
        : TTargetQuery(AOwner,ConnectionId)
{
   InstanceCount++;
   Fqry = new TADOQuery(NULL);

   if (! DBconnections) {
       DBconnections = new TList();
   }
   if ((ConnectionId <0) || (ConnectionId >= DBconnections->Count)) {
      throw Exception ("ConnectionId is out of range");
   }
   Fqry->Connection = static_cast<TADOConnection*> (DBconnections->Items[ConnectionId]);
}
//---------------------------------------------------------------------------
__fastcall TAADOQuery::~TAADOQuery()
{
   delete Fqry;
   InstanceCount--;
   if (InstanceCount ==0) {
      DBconnections->Clear();
      delete DBconnections;
      DBconnections = NULL;
   }
}
//---------------------------------------------------------------------------
void TAADOQuery::AddConnection(TADOConnection* value)
{
    if (!DBconnections) {
        DBconnections = new TList();
    }
    DBconnections->Add(value);
}
//---------------------------------------------------------------------------
Db::TDataSource* __fastcall TAADOQuery::GetDataSource(void)
{
    return Fqry->DataSource;
}
//---------------------------------------------------------------------------
void __fastcall TAADOQuery::SetDataSource(Db::TDataSource* value)
{
    Fqry->DataSource = value;
}
//---------------------------------------------------------------------------
Classes::TStrings* __fastcall TAADOQuery::GetSQL()
{
    return Fqry->SQL;
}
//---------------------------------------------------------------------------
void __fastcall TAADOQuery::SetSQL(Classes::TStrings* value)
{
    Fqry->SQL = value;
}
//---------------------------------------------------------------------------
void __fastcall TAADOQuery::ExecSQL(void)
{
    Fqry->ExecSQL();
}
//---------------------------------------------------------------------------
void __fastcall TAADOQuery::Open(void)
{
    Fqry->Open();
}
//---------------------------------------------------------------------------
int  __fastcall TAADOQuery::GetRecordCount()
{
    return Fqry->RecordCount;
}
//---------------------------------------------------------------------------
Db::TParam* __fastcall TAADOQuery::ParamByName(const AnsiString pName)
{
   bool InList = false;
   Variant pValue = Fqry->Parameters->ParamByName(pName)->Value;
   for (int i = 0; i < Params->Count; i++){
       if (Params->Items[i]->Name == pName ) {
           InList = true;
           Params->ParamByName(pName)->Value = pValue;
           break;
       }
   }
   if (!InList) {
      TParam * P = new TParam(Params);
      P->Name  = pName;
      P->Value = pValue;
   }
   return Params->ParamByName(pName);
}
//---------------------------------------------------------------------------
void __fastcall TAADOQuery::Prepare(void)
{
//   Fqry->Prepare(); not a member of ADO query
}
//---------------------------------------------------------------------------
void __fastcall TAADOQuery::UnPrepare(void)
{
//   Fqry->UnPrepare(); not a member of ADO query
}
//---------------------------------------------------------------------------
bool __fastcall TAADOQuery::GetPrepare()
{
   return Fqry->Prepared;
}
//---------------------------------------------------------------------------
void __fastcall TAADOQuery::SetPrepare(bool value)
{
   Fqry->Prepared = value;
}
//---------------------------------------------------------------------------
Word __fastcall TAADOQuery::GetParamsCount()
{
   return Fqry->Parameters->Count;
}
//---------------------------------------------------------------------------
int  __fastcall TAADOQuery::GetRowsAffected()
{
  return Fqry->RowsAffected;
}
//---------------------------------------------------------------------------
bool __fastcall TAADOQuery::GetParamCheck()
{
   return Fqry->ParamCheck;
}
//---------------------------------------------------------------------------
void __fastcall TAADOQuery::SetParamCheck(bool value)
{
   Fqry->ParamCheck = value;
}
//---------------------------------------------------------------------------
Db::TParams* __fastcall TAADOQuery::GetParams()
{
   //Make sure that returned values correspond exactly with Parameters
   Params->Clear();

   for (int i = 0; i <= Fqry->Parameters->Count; i++)
   {
      TParamType atype;
      switch (Fqry->Parameters->Items[i]->Direction)
      {
        case pdUnknown:     atype = ptUnknown;  break;
        case pdInput:       atype = ptInput;    break;
        case pdOutput:      atype = ptOutput;   break;
        case pdInputOutput: atype = ptInputOutput; break;
        case pdReturnValue: atype = ptResult;   break;
      }
      Db::TParam* aParam = Params->CreateParam(
                    Fqry->Parameters->Items[i]->DataType,
                    Fqry->Parameters->Items[i]->Name,
                    atype
                );
      aParam->Value = Fqry->Parameters->Items[i]->Value;
   }
   return Params;
}
//---------------------------------------------------------------------------
void __fastcall TAADOQuery::SetParams(Db::TParams* parms)
{
   Fqry->Parameters->Clear(); //Ensure that Parameters are same as Params
   for (int i = 0; i <= parms->Count; i++)
   {
      TParameterDirection aDir;
      switch (parms->Items[i]->ParamType)
      {
        case ptUnknown:  aDir = pdUnknown;  break;
        case ptInput:    aDir = pdInput;    break;
        case ptOutput:   aDir = pdOutput;   break;
        case ptInputOutput: aDir=pdInputOutput; break;
        case ptResult:   aDir = pdReturnValue;   break;
      }

      Fqry->Parameters->CreateParameter(
                        parms->Items[i]->Name,
                        parms->Items[i]->DataType,
                        aDir,
                        (parms->Items[i]->DataType==ftString? 255:0),
                        parms->Items[i]->Value);

   }
}
//---------------------------------------------------------------------------
TField* TAADOQuery::FieldByName(AnsiString val)
{
    return Fqry->FieldByName(val);
}
//---------------------------------------------------------------------------
void TAADOQuery::Next()
{
   Fqry->Next();
}
//---------------------------------------------------------------------------
void TAADOQuery::First()
{
  Fqry->First();
}
//---------------------------------------------------------------------------
