//---------------------------------------------------------------------------
#ifndef AADOQueryUH
#define AADOQueryUH
#include "TargetQueryU.h"
#include "ADOdb.hpp"
#include <db.hpp>
//---------------------------------------------------------------------------
class TAADOQuery : public TTargetQuery
{
private:
     TADOQuery* Fqry;
     static TList* DBconnections;
     static int InstanceCount;
     TParams* Params; //To map ADO parameters to BDE-style parameters

protected:
     virtual Db::TDataSource* __fastcall GetDataSource(void);
     virtual void __fastcall SetDataSource(Db::TDataSource* value);
     virtual Classes::TStrings* __fastcall GetSQL();
     virtual void __fastcall SetSQL(Classes::TStrings*);
     virtual int  __fastcall   GetRecordCount();
     virtual bool __fastcall GetPrepare();
     virtual void __fastcall SetPrepare(bool);
     virtual Word __fastcall GetParamsCount();
     virtual int  __fastcall GetRowsAffected();
     virtual bool __fastcall GetParamCheck();
     virtual void __fastcall SetParamCheck(bool);
     virtual Db::TParams* __fastcall GetParams();
     virtual void __fastcall SetParams(Db::TParams*);
public:
  __fastcall TAADOQuery(Classes::TComponent* AOwner, int ConnectionId);
  __fastcall ~TAADOQuery();
  static void AddConnection(TADOConnection*);

  virtual void __fastcall ExecSQL(void);
  virtual void __fastcall Open(void);
  virtual Db::TParam* __fastcall ParamByName(const AnsiString Value);
  virtual void __fastcall Prepare(void);
  virtual void __fastcall UnPrepare(void);
  __property bool Prepared = {read=GetPrepare, write=SetPrepare};
  virtual TField* FieldByName(AnsiString);
  virtual void Next();
  virtual void First();

};
TList* TAADOQuery::DBconnections=NULL;
int TAADOQuery::InstanceCount = 0;

#endif
