//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include "ABDEQueryU.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
__fastcall TABDEQuery::TABDEQuery(Classes::TComponent* AOwner, int ConnectionId)
        : TTargetQuery(AOwner,ConnectionId)
{
   InstanceCount++;
   Fqry = new TQuery(NULL);

   if (! DBconnections) {
       DBconnections = new TList();
   }
   if ((ConnectionId <0) || (ConnectionId >= DBconnections->Count)) {
      throw Exception ("ConnectionId is out of range");
   }
   TDatabase* DB = static_cast<TDatabase*> (DBconnections->Items[ConnectionId]);
   Fqry->DatabaseName = DB->DatabaseName;
}
//---------------------------------------------------------------------------
__fastcall TABDEQuery::~TABDEQuery()
{
   delete Fqry;
   InstanceCount--;
   if (InstanceCount ==0) {
      DBconnections->Clear();
      delete DBconnections;
      DBconnections = NULL;
   }
}
//---------------------------------------------------------------------------
void TABDEQuery::AddConnection(TDatabase* value)
{
  if (!DBconnections) {
      DBconnections = new TList();
  }
  DBconnections->Add(value);
}
//---------------------------------------------------------------------------
Db::TDataSource* __fastcall TABDEQuery::GetDataSource(void)
{
    return Fqry->DataSource;
}
//---------------------------------------------------------------------------
void __fastcall TABDEQuery::SetDataSource(Db::TDataSource* value)
{
    Fqry->DataSource = value;
}
//---------------------------------------------------------------------------
Classes::TStrings* __fastcall TABDEQuery::GetSQL()
{
    return Fqry->SQL;
}
//---------------------------------------------------------------------------
void __fastcall TABDEQuery::SetSQL(Classes::TStrings* value)
{
    Fqry->SQL = value;
}
//---------------------------------------------------------------------------
void __fastcall TABDEQuery::ExecSQL(void)
{
    Fqry->ExecSQL();
}
//---------------------------------------------------------------------------
void __fastcall TABDEQuery::Open(void)
{
    Fqry->Open();
}
//---------------------------------------------------------------------------
int  __fastcall TABDEQuery::GetRecordCount()
{
    return Fqry->RecordCount;
}
//---------------------------------------------------------------------------
Db::TParam* __fastcall TABDEQuery::ParamByName(const AnsiString Value)
{

    return Fqry->ParamByName(Value);
}
//---------------------------------------------------------------------------
void __fastcall TABDEQuery::Prepare(void)
{
   Fqry->Prepare();
}
//---------------------------------------------------------------------------
void __fastcall TABDEQuery::UnPrepare(void)
{
   Fqry->UnPrepare();
}
//---------------------------------------------------------------------------
bool __fastcall TABDEQuery::GetPrepare()
{
   return Fqry->Prepared;
}
//---------------------------------------------------------------------------
void __fastcall TABDEQuery::SetPrepare(bool value)
{
   Fqry->Prepared = value;
}
//---------------------------------------------------------------------------
Word __fastcall TABDEQuery::GetParamsCount()
{
   return Fqry->Params->Count;
}
//---------------------------------------------------------------------------
int  __fastcall TABDEQuery::GetRowsAffected()
{
  return Fqry->RowsAffected;
}
//---------------------------------------------------------------------------
bool __fastcall TABDEQuery::GetParamCheck()
{
   return Fqry->ParamCheck;
}
//---------------------------------------------------------------------------
void __fastcall TABDEQuery::SetParamCheck(bool value)
{
   Fqry->ParamCheck = value;
}
//---------------------------------------------------------------------------
Db::TParams* __fastcall TABDEQuery::GetParams()
{
   return Fqry->Params;
}
//---------------------------------------------------------------------------
void __fastcall TABDEQuery::SetParams(Db::TParams* value)
{
  Fqry->Params = value;
}
//---------------------------------------------------------------------------
TField* TABDEQuery::FieldByName(AnsiString val)
{
   return Fqry->FieldByName(val);
}
//---------------------------------------------------------------------------
void TABDEQuery::Next()
{
   Fqry->Next();
}
//---------------------------------------------------------------------------
void TABDEQuery::First()
{
  Fqry->First();
}
//---------------------------------------------------------------------------
