//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include "AIBQueryU.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
__fastcall TAIBQuery::TAIBQuery(Classes::TComponent* AOwner, int ConnectionId)
        : TTargetQuery(AOwner,ConnectionId)
{
   InstanceCount++;
   Fqry = new TIBQuery(NULL);

   if (! DBconnections) {
       DBconnections = new TList();
   }
   if ((ConnectionId <0) || (ConnectionId >= DBconnections->Count)) {
      throw Exception ("ConnectionId is out of range");
   }
   Fqry->Database = static_cast<TIBDatabase*> (DBconnections->Items[ConnectionId]);

}
//---------------------------------------------------------------------------
__fastcall TAIBQuery::~TAIBQuery()
{
   delete Fqry;
   InstanceCount--;
   if (InstanceCount ==0) {
      DBconnections->Clear();
      delete DBconnections;
      DBconnections = NULL;
   }
}
//---------------------------------------------------------------------------
void TAIBQuery::AddConnection(TIBDatabase* value)
{
    if (!DBconnections) {
        DBconnections = new TList();
    }
    DBconnections->Add(value);
}
//---------------------------------------------------------------------------
Db::TDataSource* __fastcall TAIBQuery::GetDataSource(void)
{
    return Fqry->DataSource;
}
//---------------------------------------------------------------------------
void __fastcall TAIBQuery::SetDataSource(Db::TDataSource* value)
{
    Fqry->DataSource = value;
}
//---------------------------------------------------------------------------
Classes::TStrings* __fastcall TAIBQuery::GetSQL()
{
    return Fqry->SQL;
}
//---------------------------------------------------------------------------
void __fastcall TAIBQuery::SetSQL(Classes::TStrings* value)
{
    Fqry->SQL = value;
}
//---------------------------------------------------------------------------
void __fastcall TAIBQuery::ExecSQL(void)
{
    Fqry->ExecSQL();
}
//---------------------------------------------------------------------------
void __fastcall TAIBQuery::Open(void)
{
    Fqry->Open();
}
//---------------------------------------------------------------------------
int  __fastcall TAIBQuery::GetRecordCount()
{
    return Fqry->RecordCount;
}
//---------------------------------------------------------------------------
Db::TParam* __fastcall TAIBQuery::ParamByName(const AnsiString Value)
{
    return Fqry->ParamByName(Value); 
}
//---------------------------------------------------------------------------
void __fastcall TAIBQuery::Prepare(void)
{
   Fqry->Prepare();
}
//---------------------------------------------------------------------------
void __fastcall TAIBQuery::UnPrepare(void)
{
   Fqry->UnPrepare(); 
}
//---------------------------------------------------------------------------
bool __fastcall TAIBQuery::GetPrepare()
{
   return Fqry->Prepared;
}
//---------------------------------------------------------------------------
void __fastcall TAIBQuery::SetPrepare(bool value)
{
   Fqry->Prepared = value;
}
//---------------------------------------------------------------------------
Word __fastcall TAIBQuery::GetParamsCount()
{
   return Fqry->Params->Count;
}
//---------------------------------------------------------------------------
int  __fastcall TAIBQuery::GetRowsAffected()
{
  return Fqry->RowsAffected;
}
//---------------------------------------------------------------------------
bool __fastcall TAIBQuery::GetParamCheck()
{
   return Fqry->ParamCheck;
}
//---------------------------------------------------------------------------
void __fastcall TAIBQuery::SetParamCheck(bool value)
{
   Fqry->ParamCheck = value;
}
//---------------------------------------------------------------------------
Db::TParams* __fastcall TAIBQuery::GetParams()
{
   return Fqry->Params;
}
//---------------------------------------------------------------------------
void __fastcall TAIBQuery::SetParams(Db::TParams* value)
{
   Fqry->Params = value;
}
//---------------------------------------------------------------------------
TField* TAIBQuery::FieldByName(AnsiString val)
{
   return Fqry->FieldByName(val);
}
//---------------------------------------------------------------------------
void TAIBQuery::Next()
{
   Fqry->Next();
}
//---------------------------------------------------------------------------
void TAIBQuery::First()
{
  Fqry->First();
}
//---------------------------------------------------------------------------
